<?php
class StringIterator implements Iterator {
  private $string;
  private $position;

  public function __construct($string) {
    $this->string = explode(' ', $string);
  }

  public function rewind() {
    $this->position = 0;
  }

  public function valid() {
    return $this->position < sizeof($this->string);
  }

  public function key() {
    return $this->position;
  }

  public function current() {
    return $this->string[$this->position];
  }

  public function next() {
    $this->position++;
  }
}
?>
