<?php
require_once 'PHPUnit2/Framework/Assert.php';
require_once 'PHPUnit2/Framework/Test.php';
require_once 'PHPUnit2/Framework/TestResult.php';

class PHPUnit2_Extensions_TestDecorator
extends PHPUnit2_Framework_Assert
implements PHPUnit2_Framework_Test {
  protected $test = NULL;

  public function
  __construct(PHPUnit2_Framework_Test $test) {
    $this->test = $test;
  }

  public function toString() {
    return $this->test->toString();
  }

  public function
  basicRun(PHPUnit2_Framework_TestResult $result) {
    $this->test->run($result);
  }

  public function countTestCases() {
    return $this->test->countTestCases();
  }

  protected function createResult() {
    return new PHPUnit2_Framework_TestResult;
  }

  public function getTest() {
    return $this->test;
  }

  public function
  run(PHPUnit2_Framework_TestResult $result) {
    $this->basicRun($result);
    return $result;
  }
}
?>
