<?php
require_once 'PHPUnit2/Framework/Test.php';
require_once 'PHPUnit2/Framework/TestResult.php';
require_once 'PHPUnit2/Extensions/TestDecorator.php';

class PHPUnit2_Extensions_RepeatedTest
extends PHPUnit2_Extensions_TestDecorator {
  private $timesRepeat = 1;

  public function
  __construct(PHPUnit2_Framework_Test $test,
              $timesRepeat = 1) {
      parent::__construct($test);

      if (is_integer($timesRepeat) &&
          $timesRepeat >= 0) {
          $this->timesRepeat = $timesRepeat;
      } else {
          throw new Exception('Nieprawidowy parametr.');
      }
  }

  public function countTestCases() {
      return $this->timesRepeat *
             $this->test->countTestCases();
  }

  public function
  run(PHPUnit2_Framework_TestResult $result) {
    for ($i = 0;
         $i < $this->timesRepeat && !$result->shouldStop();
         $i++) {
      $this->test->run($result);
    }

    return $result;
  }
}
?>
