<?php
abstract class PartnerInterface {
  protected function __construct() {}

  public static function factory($type) {
    $source = 'PartnerInterface/' . $type . '.php';

    if (@require_once($source)) {
      $class  = 'PartnerInterface_' . $type;
      $object = new $class;

      return $object;
    } else {
      throw new Exception(
        sprintf(
          'Nie mona utworzy obiektu typu %s.',
          'PartnerInterface_' . $type
        )
      );
    }
  }

  public abstract function import($data);
  public abstract function export();
}
?>
