<?php
require_once 'PHPUnit2/Framework/TestListener.php';

class SimpleTestListener
implements PHPUnit2_Framework_TestListener {
  public function
  addError(PHPUnit2_Framework_Test $test, Exception $e) {
    printf(
      'W czasie wykonywania przypadku testowego "%s"' .
      " wystpi bd.\n",
      $test->getName()
    );
  }

  public function
  addFailure(PHPUnit2_Framework_Test $test,
             PHPUnit2_Framework_AssertionFailedError $e) {
    printf(
      "Wykonanie przypadku testowego \"%s\" zakoczyo si niepowodzeniem.\n",
      $test->getName()
    );
  }

  public function
  addIncompleteTest(PHPUnit2_Framework_Test $test,
                    Exception $e) {
    printf(
      "Prypadek testowy \"%s\" nie zosta jeszcze zaimplementowany.\n",
      $test->getName()
    );
  }

  public function startTest(PHPUnit2_Framework_Test $test) {
    printf(
      "Rozpoczto wykonywanie przypadku testowego \"%s\".\n",
      $test->getName()
    );
  }

  public function endTest(PHPUnit2_Framework_Test $test) {
    printf(
      "Zakoczono wykonywanie przypadku testowego \"%s\".\n",
      $test->getName()
    );
  }

  public function
  startTestSuite(PHPUnit2_Framework_TestSuite $suite) {
  }

  public function
  endTestSuite(PHPUnit2_Framework_TestSuite $suite) {
  }
}
?>
