<?php
abstract class PHPUnit2_Extensions_CodeCoverage_Renderer {
  protected $codeCoverageInformation;

  protected function __construct($codeCoverageInformation) {
    $this->codeCoverageInformation = $codeCoverageInformation;
  }

  public function factory($type, $codeCoverageInformation) {
    $class = 'PHPUnit2_Extensions_CodeCoverage_Renderer_' .
             $type;

    $source = 'PHPUnit2/Extensions/CodeCoverage/Renderer/' .
              $type . '.php';

    if (@require_once($source)) {
        $object = new $class($codeCoverageInformation);

      return $object;
    } else {
      throw new Exception(
        sprintf(
          'Could not load class %s.',
          $class
        )
      );
    }
  }

  public final function render() {
    $buffer = '';

    foreach ($this->codeCoverageInformation as
             $testCaseName => $sourceFiles) {
      $buffer .= $this->startTestCase($testCaseName);

      foreach ($sourceFiles as
               $sourceFile => $executedLines) {
        $buffer .= $this->startSourceFile($sourceFile);

        $buffer .= $this->renderSourceFile(
          file($sourceFile),
          $executedLines
        );

        $buffer .= $this->endSourceFile($sourceFile);
      }

      $buffer .= $this->endTestCase($testCaseName);
    }

    return $buffer;
  }

  protected function startTestCase($testCaseName) {
  }

  protected function endTestCase($testCaseName) {
  }

  protected function startSourceFile($sourceFile) {
  }

  protected function endSourceFile($sourceFile) {
  }

  abstract protected function
  renderSourceFile($codeLines, $executedLines);
}
?>
