DROP TABLE IF EXISTS author;
CREATE TABLE author(
  author_id     INTEGER      NOT NULL COMMENT 'Identyfikator autora',
  first_name    VARCHAR(128) NOT NULL COMMENT 'Imi autora',
  last_name     VARCHAR(128) NOT NULL COMMENT 'Nazwisko autora',

  PRIMARY KEY (author_id)
) TYPE=InnoDB COMMENT='Tabela autorw';

DROP TABLE IF EXISTS publisher;
CREATE TABLE publisher(
  publisher_id  INTEGER      NOT NULL COMMENT 'Identyfikator wydawcy',
  name          VARCHAR(128) NOT NULL COMMENT 'Nazwa wydawcy',

  PRIMARY KEY (publisher_id)
) TYPE=InnoDB COMMENT='Tabela wydawcw';

DROP TABLE IF EXISTS book;
CREATE TABLE book(
  book_id       INTEGER      NOT NULL COMMENT 'Identyfikator ksizki',
  title         VARCHAR(255) NOT NULL COMMENT 'Tytu ksiki',
  isbn          VARCHAR(24)  NOT NULL COMMENT 'Numer ISBN',
  author_id     INTEGER      NOT NULL COMMENT 'Klucz obcy autora',
  publisher_id  INTEGER      NOT NULL COMMENT 'Klucz obcy Wydawcy',

  PRIMARY KEY (book_id),
  INDEX (author_id),
  FOREIGN KEY (author_id)    REFERENCES author    (author_id),
  INDEX (publisher_id),
  FOREIGN KEY (publisher_id) REFERENCES publisher (publisher_id)
) TYPE=InnoDB COMMENT='Tabela ksiek';
