<?php
// Wczenie biblioteki obsugi iteratora z informacjami o indeksach.
require 'KeyArrayIterator.php';

// Deklaracja nowej klasy, ktra rozszerza poprzedni i implementuje
// zdolno rekurencji.
class RecursiveKeyArrayIterator extends KeyArrayIterator
                                implements RecursiveIterator {
    // W tym celu naley zdefiniowa dwie metody.  Po pierwsze,
    // naley zdefiniowa funkcj sprawdzajc, czy s potomkowie.
    public function hasChildren() {
        // W tym przypadku potomek oznacza element bdcy tablic.
        return is_array($this->current()->value);
    }

    // Nastpnie naley zdefiniowa metod, ktra zwraca potomkw.
    public function getChildren() {
        // Dostp do potomkw uzyskamy za pomoc iteratora,
        // dlatego w tym miejscu definiujemy nowy iterator.
        return new RecursiveKeyArrayIterator($this->current()->value);
    }
}

// To wszystko, co trzeba byo zrobi. W celu przetestowania rozwizania utworzymy tablic.
$arr = array(42, array(1973, 1974, 2005), 173, array('Tatiana', 'Lidia'), 'a');

// Utworzenie iteratora.
$it = new RecursiveIteratorIterator(new RecursiveKeyArrayIterator($arr));

// Przegldanie tablicy w ptli i wywietlanie indeksw wraz z gbokoci!
foreach ($it as $entry) {
    echo $it->getDepth(), ' - ', $entry->key, ' - ', $entry, "<br />\n";
}
?>
