<?php
// Deklaracja nowej klasy, ktra rozszerza klas FilterIterator.
class RegexFilterIterator extends FilterIterator {
    // Deklaracja waciwoci, w ktrej zostan zapisane kryteria filtru.
    private $criteria;

    // Utworzenie konstruktora, ktry pobiera iterator i wyraenie regularne.
    public function __construct(Iterator $i, $regex) {
        // Wywoanie konstruktora klasy nadrzdnej i zapisanie wyraenia regularnego.
        parent::__construct($i);
        $this->criteria = $regex;
    }

    // Zdefiniowanie metody accept w celu obsugi wyraenia regularnego.
    public function accept() {
        // Sprawdzenie, czy biecy element spenia kryteria wyraenia regularnego.
        return preg_match($this->criteria, parent::current());
    }
}

// W celu przetestowania iteratora najpierw definiujemy tablic wartoci.
$arr = array('Mirek', 'Augustyn', 'Tomek', 'Teofil', 'Krzysztof', 'Henryk', 'Sta');

// Utworzenie poczonego iteratora. Zdefiniowanie iteratora FilterIterator, ktry
// otacza iterator ArrayIterator i dopuszcza tylko te elementy, ktre zawieraj liter 'y'.
$it = new RegexFilterIterator(new ArrayIterator($arr), '/y/i');

// Przetwarzanie iteratora w ptli i wywietlenie jego wszystkich elementw. W wyniku powinny wywietli si 
// imiona Augustyn, Krzysztof i Henryk.
foreach ($it as $entry) { echo "{$entry}<br />\n"; }
?>

