<?php
// Zadeklarowanie nowej klasy, ktra implementuje interfejs Iterator. Klasa ta
// pozwoli na bardziej naturalne przegldanie tablic oraz na dostp do indeksw.
class KeyArrayIterator implements Iterator {
    // Deklaracja waciwoci, w ktrej zostanie zapisana tablica z danymi.
    protected $data;

    // Utworzenie konstruktora.
    public function __construct($v) {
        // Zapisanie danych w chronionej waciwoci.
        $this->data = $v;
    }

    // W ramach implementacji interfejsu Iterator naley zaimplementowa metod 'rewind'.
    public function rewind() {
        // Dane s zapisane w tablicy, zatem skorzystamy z funkcji obsugi tablicy.
        return reset($this->data);
    }

    // W ramach implementacji interfejsu Iterator naley zadeklarowa metod 'next', ktra przesuwa wskanik 
        // w przd.
    public function next() {
        // Skorzystanie z funkcji obsugi tablicy.
        return next($this->data);
    }

    // W ramach implementacji interfejsu Iterator naley zdefiniowa metod 'valid', ktra zwraca
    // informacj na temat tego, czy wskanik ma prawidow warto.
    public function valid() {
        // Uycie funkcji 'current' w celu sprawdzenia, czy
        // wskanik wskazuje prawidowy element tablicy.
        return (current($this->data) === false) ? false : true;
    }

    // Potrzebna jest rwnie metoda 'key', ktra zwraca indeks biecego elementu.
    public function key() {
        // W tym celu skorzystamy z wbudowanej funkcji obsugi tablic  'key'.
        return key($this->data);
    }

    // Na koniec potrzebna jest metoda 'current'  sedno tego obiektu.
    public function current() {
        // Metoda 'current' zwraca biecy element. Chcemy jednak, by 
        // zwracaa obiekt zawierajcy zarwno warto elementu,
        // jak i jego indeks. W tym celu wystarczy wykona kolejn instrukcj.
        return new KeyArrayItem(key($this->data), current($this->data));
    }
}

// Teraz naley zdefiniowa klas KeyArrayItem, ktrej uyto w
// funkcji 'current' iteratora.
class KeyArrayItem {
    // Najpierw zadeklarujemy waciwoci, w ktrych zostan zapisane dane.
    public $key;
    public $value;

    // Nastpnie utworzymy konstruktor, ktry pobiera indeks i warto.
    public function __construct($k, $v) {
        // Zapisujemy wartoci.
        $this->key = $k;
        $this->value = $v;
    }

    // Na koniec zdefiniujemy metod __toString, ktra zwraca
    // warto elementu w przypadku bezporedniego dostpu do obiektu.
    public function __toString() {
        return (string) $this->value;
    }
}
?>
