<?php
// Wygenerowanie grafiki CAPTCHA.

// Utworzenie nowego obrazu i ustawienie jego wymiarw.
$w = 300;
$h = 50;
$gfx = imagecreatetruecolor($w, $h);

// Wczenie efektu wygadzania (anti-aliasing) w celu polepszenia wygldu zaokrglonych krawdzi.
imageantialias($gfx, true);

// Zadeklarowanie biaego koloru jako koloru ta.
$white = imagecolorallocate($gfx, 255, 255, 255);
imagefilledrectangle($gfx, 0, 0, $w-1, $h-1, $white);

// Wygenerowanie cigu skadajcego si z 6-8 znakw  samych wielkich liter.
$str = '';
foreach (range(0, rand(5,7)) as $r) {
    $str .= chr(rand(65,90));
}

// Podzielenie szerokoci przez liczb znakw w celu znalezienia przyblionych pozycji
// poszczeglnych znakw.
$pos = $w / strlen($str);

// Ptla wywietlajca znaki.
foreach(range(0, strlen($str) - 1) as $s) {
    // Losowe wygenerowanie koloru  stopnia szaroci, ale tylko spord ciemnych odcieni.
    $shade = rand(0, 100);

    // Zadeklarowanie koloru.
    $tmpgray = imagecolorallocate($gfx, $shade, $shade, $shade);

    // Wywietlenie znaku z wykorzystaniem
    // znieksztace:
    imagettftext($gfx,     // Obiekt graficzny, w ktrym wykrelimy tekst.
        rand($h/3, $h/2),  // Rozmiar czcionki pomidzy 1/3 a 1/2 penej wysokoci.
        rand(-60, 60),     // Losowy kt nachylenia.
        $s*$pos+($pos*.4), // Wsprzdna X w rwnych odstpach.
        rand($h*.5,$h*.7), // Wsprzdna Y  zmienna. Poowa wysokoci lub nieco wicej.
        $tmpgray,          // Kolor znaku  szary.
        'arial',           // Zastosowana czcionka.
        $str{$s});         // Wywietlenie znaku.
}

// Umieszczenie w tle losowo rozmieszczonych szarych linii o rnych odcieniach szaroci.
// Ptla od wartoci przeciwnej wysokoci do wartoci szerokoci w celu zapewnienia rysowania na obrazie.
foreach(range(-$h, $w, 5) as $x) {
    // Losowe wygenerowanie odcienia szaroci z wyczeniem odcieni najciemniejszych.
    $shade = rand(50,254);
    $tmpgray = imagecolorallocate($gfx, $shade, $shade, $shade);

    // Wykrelenie dwch linii  skonej w d i skonej w gr
    // pod losowymi ktami.
    imageline($gfx, $x, 0, $x+$h+rand(0,25), $h-1, $tmpgray);
    imageline($gfx, $x, $h-1, $x+$h+rand(0,25), 0, $tmpgray);
}

// Wszystkie operacje wykonano. Przed wyprowadzeniem wyniku
// ustawimy cig jako zmienn sesji.
session_start();
$_SESSION['captcha'] = $str;

// Poinformowanie przegldarki o formacie wynikowym  PNG.
header('Content-type: image/png');

// Wyprowadzenie zmodyfikowanego obrazu.
imagepng($gfx);
?>
