<?php
// Zdefiniowanie wasnego mechanizmu obsugi bdw w celu uzyskania bardziej szczegowych 
// komunikatw o bdach
function detailed_err($errno, $errstr, $errfile, $errline, $errcontext) {
    // Odnotowanie faktu wystpienia bdu krytycznego oraz podstawowych informacji,
    // takich jak w przypadku standardowego raportu o bdzie.
    echo "<p>BD KRYTYCZNY - {$errstr}</p>\n";

    // Wykorzystanie funkcji debug_print_backtrace w celu przekazania listy wywoa funkcji
    // w formacie umoliwiajcym jego atwe przeszukiwanie.
    echo "<pre>\nDrzewo wywoa funkcji:\n";
    debug_print_backtrace();

    // W celu uzupenienia 'superdokadnego' trybu diagnostycznego dodamy
    // kompletny lad zawierajcy wszystkie zdefiniowane zmienne 
    // oraz wiele innych informacji.
    echo "\nKompletny lad:\n";
    var_dump(debug_backtrace());

    // Zamknicie znacznika pre.
    echo "</pre>\n";

    // Zakoczenie dziaania skryptu.
    die();
}

// Rejestracja nowej procedury obsugi bdw.
set_error_handler('detailed_err', E_ERROR | E_USER_ERROR);
?>
