<?php
// Zadeklarowanie globalnej tablicy przeznaczonej do zapisania danych.
$_timer_results = array();

// Funkcja, ktra dodaje nowe wyniki pomiaru czasu do globalnej tablicy.
function _timer() {
    global $_timer_results;

    // Odczytanie czasu w mikrosekundach.
    $curtime = microtime(true);

    // Odczytanie ladu, aby mona si byo dowiedzie, skd wywoano funkcj.
    $trace = debug_backtrace();

    // Element [0] odnosi si do teraniejszoci wewntrz ladu, zatem skorzystamy z niego
    // w celu okrelenia nazwy pliku i numeru wiersza. Nazw funkcji wywoujcej,
    // jeli taka istnieje, mona odczyta z elementu [1].
    $_timer_results[] = array(
        'line' => $trace[0]['line'],
        'file' => $trace[0]['file'],
        'func' => isset($trace[1]['function']) ? $trace[1]['function'] : '',
        'time' => $curtime
        );
}

// Wywoanie funkcji _timer w celu rozpoczcia pomiaru czasu
// na pocztku dziaania skryptu.
_timer();

// Funkcja przeksztacajca wyniki na bardziej czyteln posta.
// Zwraca tekst, ktry mona wykorzysta na wiele sposobw:
// wywietli, wyprowadzi jako komentarz HTML itp.
function _timer_text() {
    global $_timer_results;
    $result = 'Wyniki pomiaru';

    // Pocztek pomiaru czasu od znacznika czasu pierwszego uruchomienia skryptu.
    $clock = @$_timer_results[0]['time'];

    // Przetwarzanie w ptli wszystkich elementw tablicy wynikw w celu utworzenia tekstu.
    foreach ($_timer_results as $tr) {
        // Obliczenie, ile czasu zajo wykonywanie skryptu od punktu pocztkowego.
        $thistime = $tr['time'] - $clock;

        // Zresetowanie zegara w celu wykonania nastpnej iteracji.
        $clock = $tr['time'];

        // Odczytanie nazwy pliku.
        $fn = basename($tr['file']);

        // W celu uzyskania bardziej estetycznego wyniku
        // zaokrglimy wynik do piciu miejsc po przecinku.
        // Wiksza dokadno nie jest potrzebna.
        $pretty = number_format($thistime, 5);

        // Utworzenie i dodanie tekstu do wynikw.
        $result .= "\n{$pretty} sek. - Plik: {$fn} - Wiersz: {$tr['line']}";

        // Dodanie informacji o funkcji wywoujcej, jeli jest dostpna.
        if ($tr['func']) {
            $result .= " - Funkcja wywoujca: {$tr['func']}";
        }
    }

    // Zwrcenie wyniku.
    return $result;
}
?>
