<?php
// Rozszerzenie klasy Exception w celu utworzenia wyjtku zgaszanego dla liczby mniejszej od dolnej 
// dopuszczalnej granicy.
class LessThanException extends Exception {
    // Utworzenie zmiennej zawierajcej minimaln dozwolon warto liczby.
    private $number;

    // Definicja konstruktora ustawiajcego warto liczby.
    public function __construct($num) {
        // Zapisanie liczby.
        $this->number = $num;

        // Wywoanie konstruktora klasy nadrzdnej i przekazanie danych.
        parent::__construct("Liczba bya mniejsza ni {$num}");
    }
}

// Utworzenie bardzo podobnego do poprzedniego wyjtku dla liczby wikszej od maksymalnej.
class GreaterThanException extends Exception {
    // Utworzenie zmiennej zawierajcej maksymaln dozwolon warto liczby.
    private $number;

    // Definicja konstruktora ustawiajcego warto liczby.
    public function __construct($num) {
        // Zapisanie liczby.
        $this->number = $num;

        // Wywoanie konstruktora klasy nadrzdnej i przekazanie danych.
        parent::__construct("Liczba bya wiksza ni {$num}");
    }

    // Deklaracja funkcji zwracajcej warto liczby.
    public function thanWhat() {
        return $this->number;
    }
}


// Teraz mona posuy si zdefiniowanymi wczeniej klasami opisu wyjtkw.

// Rozpoczcie bloku try tak, aby mona byo przechwyci wszystkie powstae wyjtki.
try {
    // Wygenerowanie losowej liczby w zakresie od 10 do 50.
    $num = rand(10,50);

    // Jeli liczba bya mniejsza ni 25, nie jestemy zadowoleni.
    if ($num < 25) {
        // Liczba bya mniejsza od minimalnej  zgoszenie wyjtku LessThanException,
        throw new LessThanException(25);
    }

    // Liczba nie powinna by rwnie wiksza ni 42,
    if ($num > 42) {
        // Tym razem naley zgosi wyjtek GreaterThanException.
        throw new GreaterThanException(42);
    }
}
// Prba przechwycenia bdw zwizanych z wygenerowaniem liczby mniejszej od minimalnej.
catch (LessThanException $le) {
    // Przechwycono wyjtek. Liczba bya niedozwolona  wywietlenie komunikatu o bdzie.
    die('<p>BD: LICZBA MNIEJSZA OD MINIMALNEJ: ' . $le->getMessage() . "</p>\n");
}
// Prba przechwycenia bdw dla liczb wikszych od maksymalnej.
catch (GreaterThanException $ge) {
    // Jeli liczba bya wiksza, ustawimy j na maksymaln dopuszczaln warto.
    // :
    $num = $ge->thanWhat();
}

// Liczba mieci si w dopuszczalnym zakresie  wywietlenie jej wartoci.
echo "<p>Nowa liczba wynosi: {$num}</p>\n";
?>
