<style>
div {
    text-align: center;
    border: 2px solid black;
    padding: 5px;
    margin: 10px;
}
ul {
    font-size: 9px;
    text-align: left;
}
</style>
<?php
// Definicja cieki. Zakadamy, e bdzie to cieka wzgldna, 
// dziaajca zarwno w systemie plikw, jak i w sieci.
$path = "photos/";

// Otwarcie katalogu.
$do = dir($path);

// Przegldanie katalogu w ptli  wyszukiwanie plikw JPG.
while (($file = $do->read()) !== false) {
    // Analiza rozszerzenia.
    $info = pathinfo($path . $file);

    // Kontynuacja tylko wtedy, gdy biecy plik ma format jpeg.
    if (strtolower($info['extension']) == 'jpg') {
        // Znaleziono plik JPG!  Uycie znacznika DIV w celu wywietlenia cza do pliku.
        echo "<div><a href=\"{$path}{$file}\">";

        // Prba pobrania miniaturki. W razie powodzenia wywietlenie jej.
           if ($thumb = exif_thumbnail($path . $file, $width,
                   $height, $type)) {
            // Odczytano grafik. Sprawdzenie jej typu mime.
            $mime = image_type_to_mime_type($type);

            // Wykorzystanie sztuczki zwizanej z HTML  osadzenie grafiki
            // bezporednio na stronie WWW w postaci danych zakodowanych w formacie base64.
            $encoded = base64_encode($thumb);
            echo "<img src=\"data:{$mime};base64,{$encoded}\" /><br />";
        }

        // Umieszczenie nazwy pliku w treci cza.
        echo $file, "</a>\n";

        // Prba odczytania wszystkich danych Exif.
        if ($exif = exif_read_data($path . $file)) {
            // Odczytano dane. Generujemy list w celu ich wywietlenia.
            echo "<ul>\n";

            // Przetwarzanie w ptli poszczeglnych 'sekcji' danych.
            foreach ($exif as $section => $sectiondata) {
                // Rozpoczcie nowej listy, jeli zmienna $sectiondata jest tablic.
                if (is_array($sectiondata)) {
                    // Wywietlenie nazwy sekcji i rozpoczcie nowej listy.
                    echo "<li>{$section}<ul>\n";

                    // Przetwarzanie sekcji w ptli.
                    foreach ($sectiondata as $name => $data) {
                        // Wywietlenie wiersza danych.
                        echo "<li>{$name} = ", htmlspecialchars($data),
                            "</li>\n";
                    }

                    // Zamknicie sekcji.
                    echo "</ul></li>\n";
                } else {
                    // Nie jest to sekcja, ale dane. Wywietlenie ich.
                    echo "<li>{$section} = ",
                        htmlspecialchars($sectiondata), "</li>\n";
                }
            }

            // Zamknicie caej listy.
            echo "</ul>\n";
        }

        // Zamknicie znacznika div.
        echo "</div>\n";
    }
}
?>
