<?php
// Najpierw napiszemy funkcj, ktra automatycznie tworzy ramk
// z cieniem. Funkcja przyjmuje argumenty w postaci wsprzdnych ramki
// oraz przesunicia, gdzie ma si wywietli cie. Zaoono, e cie wywietla si u dou i z prawej strony ramki.
function i_filledrectangledropshadow($g,
        $x1, $y1, $x2, $y2,
        $drop, $color, $shcolor) {
    // Wykrelenie ramki cienia odpowiednio przesunitej wzgldem ramki gwnej.
    imagefilledrectangle($g, $x1 + $drop, $y1 + $drop,
        $x2 + $drop, $y2 + $drop, $shcolor);

    // Wykrelenie gwnej ramki.
    imagefilledrectangle($g, $x1, $y1, $x2, $y2, $color);
}

// Utworzenie funkcji podobnej do powyszej, ktra tworzy prostokt z obrysem
// oraz cie. Funkcja generuje cie wygldajcy bardziej realistycznie.
function i_rectangledropshadow($g,
        $x1, $y1, $x2, $y2,
        $drop, $color, $shcolor, $border) {
    // Czas, by troch pooszukiwa. Najpierw wywoujemy poprzedni funkcj.
    i_filledrectangledropshadow($g, $x1, $y1, $x2, $y2,
        $drop, $color, $shcolor);

    // Nastpnie wykrelamy na uzyskanym obrazie zwyky prostokt.
    imagerectangle($g, $x1, $y1, $x2, $y2, $border);
}

// Funkcja wykrelajca wypeniony prostokt z zaokrglonymi naronikami.
// Argumenty funkcji s takie same, jak w przypadku rysowania zwykego prostokta, ale dodatkowo podano kt dla naronikw.
function i_filledroundedrectangle($g, $x1, $y1, $x2, $y2, $color, $radius) {
    // Potrzebna jest rwnie rednica.
    $d = $radius * 2;

    // W celu uzyskania efektu posuymy si drobnym oszustwem. Najpierw wykrelamy cztery kka
    //  w naronikach ramki:
    imagefilledellipse($g, $x1 + $radius, $y1 + $radius, $d, $d, $color);
    imagefilledellipse($g, $x2 - $radius, $y1 + $radius, $d, $d, $color);
    imagefilledellipse($g, $x1 + $radius, $y2 - $radius, $d, $d, $color);
    imagefilledellipse($g, $x2 - $radius, $y2 - $radius, $d, $d, $color);

    // Nastpnie wypeniamy rodek. W tym celu naley odpowiednio wykreli dwa prostokty.
    imagefilledrectangle($g, $x1+$radius, $y1, $x2-$radius, $y2, $color);
    imagefilledrectangle($g, $x1, $y1+$radius, $x2, $y2-$radius, $color);
}

// Wersja funkcji wykrelajca obrys prostokta z zaokrglonymi naronikami.
function i_roundedrectangle($g,
        $x1, $y1, $x2, $y2,
        $color, $border, $radius) {
    // Funkcj t mona by zaimplementowa z wykorzystaniem funkcji imagearc oraz imageline,
    // podobnie jak poprzednio. Poniewa jednak zdefiniowalimy wczeniej t funkcj,
    // moemy zastosowa sztuczk: wystarczy wywoa j dwa razy,
    // podajc kolor wypenienia i ramki.
    i_filledroundedrectangle($g, $x1, $y1, $x2, $y2, $border, $radius);
    i_filledroundedrectangle($g, $x1 + 1, $y1 + 1, $x2 - 1, $y2 - 1,
        $color, $radius);
}

// Wywoanie zdefiniowanych funkcji w celu ich przetestowania.
// Najpierw utworzymy pust ilustracj.
$gfx = imagecreatetruecolor(200, 200);

// Zadeklarowanie kilku kolorw do wykorzystania.
$black = imagecolorallocate($gfx, 0, 0, 0);
$gray = imagecolorallocate($gfx, 120, 120, 120);
$white = imagecolorallocate($gfx, 255, 255, 255);
$blue = imagecolorallocate($gfx, 0, 0, 255);

// Wiksza cz ta bdzie wypeniona biaym kolorem.
imagefilledrectangle($gfx, 1, 1, 198, 198, $white);

// Wczenie efektu wygadzania (anti-aliasing) w celu polepszenia wygldu zaokrglonych krawdzi.
imageantialias($gfx, true);

// Prba wywietlenia niebieskiej ramki z szarym cieniem.
i_filledrectangledropshadow($gfx, 5, 5, 50, 40, 5, $blue, $gray);

// Prba wywietlenia prostej biaej ramki z czarnym obrysem i szarym cieniem.
i_rectangledropshadow($gfx, 5, 60, 50, 100, 5, $white, $gray, $black);

// Wstawienie wypenionego niebieskiego prostokta z zaokrglonymi naronikami.
i_filledroundedrectangle($gfx, 70, 5, 150, 50, $blue, 15);

// Wywietlenie prostokta z zaokrglonymi naronikami bez wypenienia.
i_roundedrectangle($gfx, 70, 65, 160, 100, $white, $black, 15);

// Wywietlenie obrazu w formacie PNG.
header('Content-type: image/png');
imagepng($gfx);
?>
