<?php
// Skrypt wstawia informacj o prawach autorskich do pliku graficznego.
// Wczytanie grafiki do pamici. Jest to obraz w formacie JPEG, zatem skorzystamy z poniszej funkcji:
$gfx = imagecreatefromjpeg('eli.jpg');

// Informacj o prawach autorskich chcemy umieci u dou obrazu.
// W zwizku z tym trzeba okreli jego wymiary.
$width = imagesx($gfx);
$height = imagesy($gfx);

// Zdefiniowanie tekstu, ktry bdzie umieszczony na ilustracji.
$statement = 'Copyright 2006 - eliw.com';
$font = 'arial';

// Chcemy wykorzysta czcionk TrueType  preferowany rozmiar 11.
// Jeli tekst pisany tak czcionk bdzie zbyt szeroki, trzeba zmniejszy jej rozmiar.
foreach (range(11, 1) as $fontsize) {
    // Obliczenie wymiarw ramki otaczajcej tekst.
    $box = imagettfbbox($fontsize, 0, $font, $statement);

    // Wykorzystanie wsprzdnej X lewego dolnego naronika (0) oraz wsprzdnej X grnego
    // prawego naronika (4) do obliczenia szerokoci
    $fontw = abs($box[4] - $box[0]);

    // Czy szeroko powikszona o 4 (w celu dodania odstpw) jest mniejsza od szerokoci obrazu?
    if ($fontw + 4 <= $width) {
        // Tak. Przerwanie ptli i kontynuacja dla obliczonego rozmiaru.
        break;
    }
}

// Wysoko: wykorzystanie wsprzdnej Y lewego dolnego naronika(1) i wsprzdnej Y grnego
// prawego naronika (5) do obliczenia wysokoci.
$fonth = abs($box[5] - $box[1]);

// Chcemy rwnie wiedzie, do jakiej wartoci poniej podstawy dosiga czcionka.
// W roli podstawy wykorzystamy warto wsprzdnej Y lewego dolnego naronika.
$basel = $box[1];

// Do wykrelenia napisu bd potrzebne dwa kolory. Wywietlimy czarne to
// a na nim biay tekst. Zadeklarowanie kolorw za pomoc skadowych RGB:
$black = imagecolorallocate($gfx, 0, 0, 0);
$white = imagecolorallocate($gfx, 255, 255, 255);

// Wykrelenie prostokta w lewym dolnym naroniku jako ta tekstu.
imagefilledrectangle($gfx, $width - $fontw - 4, $height - $fonth - 4,
    $width,    $height, $black);

// Wykrelenie tekstu w prawym dolnym rogu obrazu.
imagettftext($gfx,        // Obiekt graficzny, w ktrym wykrelamy tekst.
    $fontsize,            // Rozmiar wykorzystywanej czcionki.
    0,                    // Kt wykrelania tekstu.
    $width - $fontw -2,   // Warto wsprzdnej X lewej strony tekstu.
    $height - $basel - 2, // Warto wsprzdnej Y podstawy tekstu.
    $white,               // Kolor tekstu.
    $font,                // Czcionka do wykorzystania.
    $statement);          // Tekst do wykrelenia.

// Wszystkie operacje wykonano.
// Poinformowanie przegldarki o formacie wynikowym  PNG.
header('Content-type: image/png');

// Wyprowadzenie zmodyfikowanego obrazu.
imagepng($gfx);
?>
