<?php
// Skrypt wstawia informacj o prawach autorskich do pliku graficznego.
// Wczytanie grafiki do pamici. Jest to obraz w formacie JPEG, zatem skorzystamy z poniszej funkcji:
$gfx = imagecreatefromjpeg('eli.jpg');

// Informacj o prawach autorskich chcemy umieci u dou obrazu.
// W zwizku z tym trzeba okreli jego wymiary.
$width = imagesx($gfx);
$height = imagesy($gfx);

// Zdefiniowanie tekstu, ktry zostanie umieszczony na ilustracji.
$statement = 'Copyright 2006 - eliw.com';

// Do wykrelenia tekstu uyjemy prostej, wbudowanej czcionki o staym odstpie.
// Zastosujemy rozmiar czcionki 3. Jeli jednak okae si, e napis
// bdzie zbyt szeroki, zmniejszymy j. W zwizku z tym najpierw
// przeprowadzimy kilka testw dla rnych rozmiarw czcionek.
foreach (range(3, 1) as $fontsize) {
    // Obliczenie szerokoci pojedynczego znaku wybranej czcionki.
    $fontw = imagefontwidth($fontsize);

    // Obliczenie szerokoci caego napisu.
    $fullw = strlen($statement) * $fontw;

    // Czy szeroko powikszona o 4 (w celu dodania odstpw) jest mniejsza od szerokoci obrazu?
    if ($fullw + 4 <= $width) {
        // Tak. Przerwanie ptli i kontynuacja dla obliczonego rozmiaru.
        break;
    }
}

// Odczytanie wysokoci znaku wybranej czcionki.
$fonth = imagefontheight($fontsize);

// Do wykrelenia napisu bd potrzebne dwa kolory. Wywietlimy czarne to,
// a na nim biay tekst. Zadeklarowanie kolorw za pomoc skadowych RGB.
$black = imagecolorallocate($gfx, 0, 0, 0);
$white = imagecolorallocate($gfx, 255, 255, 255);

// Tekst zostanie umieszczony w prawym dolnym rogu obrazu.
// Wok tekstu pozostawimy ramk szerokoci 2 pikseli. Bdzie ona miaa kolor czarny, tak by
// zachowa zgodno z krawdziami obrazu. Wykrelenie prostokta o wymiarach
// umoliwiajcych wykrelenie tekstu.
imagefilledrectangle($gfx, // Obiekt graficzny, w ktrym znajdzie si wykrelany tekst.
    $width - $fullw - 4,  // Warto wsprzdnej X lewego grnego naronika.
    $height - $fonth - 4, // Warto wsprzdnej Y lewego grnego naronika.
    $width,               // Warto wsprzdnej X prawego dolnego naronika.
    $height,              // Warto wsprzdnej Y prawego dolnego naronika.
    $black);              // Kolor ta.

// Wykrelenie tekstu w prawym dolnym rogu obrazu.
imagestring($gfx,         // Obiekt graficzny, w ktrym wykrelamy tekst.
    $fontsize,            // Rozmiar wykorzystywanej czcionki.
    $width - $fullw -2,   // Warto wsprzdnej X lewego grnego naronika.
    $height - $fonth - 2, // Warto wsprzdnej Y lewego grnego naronika.
    $statement,           // Tekst do wykrelenia.
    $white);              // Kolor tekstu.

// Wszystkie operacje wykonano.
// Poinformowanie przegldarki o formacie wynikowym  PNG.
header('Content-type: image/png');

// Wyprowadzenie zmodyfikowanego obrazu:
imagepng($gfx);
?>

