<?php
// Utworzenie funkcji, ktra przeksztaca kana RSS na list definicji.
function rss_dl($url) {
    // Rozpoczynamy od zaadowania kanau RSS z wykorzystaniem rozszerzenia SimpleXML.
    $rss = simplexml_load_file($url);

    // Wyprowadzenie tytuu kanau jako bloku akapitu. Pniej
    // mona skorzysta z arkuszy stylw w celu dostosowania jego wygldu.
    echo <<<EOSNIPPET
<p>
  <a href="{$rss->channel->link}">{$rss->channel->title}</a>
</p>
EOSNIPPET;

    // Pocztek listy definicji.
    echo "<dl>\n";

    // Przegldanie w ptli poszczeglnych pozycji w celu utworzenia na ich podstawie zapisw definicji.
    foreach ($rss->channel->item as $i) {
        // Tytu zawierajcy cze.
        echo "<dt><a href=\"{$i->link}\">{$i->title}</a></dt>\n";

        // Opis w postaci znacznika dd.
        echo "<dd>{$i->description}</dd>\n";
    }

    // Zakoczenie listy.
    echo "</dl>\n";
}

// Przetestowanie skryptu.
rss_dl('http://acorn.atlantia.sca.org/calendar.xml');

// Jeszcze jeden test.
echo "<br /><br /><br />\n";
rss_dl('http://rss.cnn.com/rss/cnn_topstories.rss');
?>
