<?php
// Utworzenie tablicy aktualnoci.
// Informacje te mog pochodzi z bazy danych.
$news = array(
  array('Czowiek, ktry nienawidzi polityki', 'http://przyklad.com/23423.php',
    'Znaleziono czowieka, ktry nienawidzi polityki.  Politycy s zaskoczeni.'),
  array('Kot zjada myszy', 'http://przyklad.com/83482.php',
    'Znaleziono kota, ktry jad mysz. Mysz wygldaa na bardzo zdziwion.'),
  array('Programici otrzymuj prac', 'http://przyklad.com/03912.php',
    'Programista otrzyma prac zdaln i jest bardzo szczliwy.'),
    );

// W celu utworzenia kanau RSS naley najpierw stworzy waciwy nagwek.
header('Content-type: text/xml');

// Wyprowadzenie nagwka dokumentu RSS.  W tych elementach
// opisano witryn WWW oraz temat, ktrego dotyczy kana RSS:
echo '<?xml version="1.0" ?>';
echo <<<EORSS

<rss version="2.0">
  <channel>
    <title>Niezbyt intrygujce aktualnoci (NSNNS)</title>
    <link>http://example.com/nsnns.php</link>
    <description>Najciekawsze aktualnoci, jakie mona znale!</description>
    <language>pl-pl</language>
    <copyright>Copyright 2006 - NSNNS</copyright>
    <webMaster>webmaster@przyklad.com</webMaster>
    <generator>Skrypt PHP</generator>
EORSS;

// Teraz mona wywietli poszczeglne pozycje aktualnoci.
// Aby to zrobi, rozpoczniemy ich przegldanie w ptli!
foreach ($news as $item) {
    // Nie s potrzebne zbyt wyszukane operacje  wystarczy je wywietli.
    echo <<<EOITEM

    <item>
      <title>{$item[0]}</title>
      <link>{$item[1]}</link>
      <description>{$item[2]}</description>
    </item>
EOITEM;
}

// To prawie wszystko. Wystarczy jeszcze wywietli kilka znacznikw zamykajcych i na tym koniec.
echo <<<EOCLOSE

  </channel>
</rss>
EOCLOSE;
?>

