<?php
// Wykorzystanie rozszerzenia DOM w celu zaadowania pliku XML do pamici.
$dom = new DOMDocument();
$dom->load('contacts.xml');

// Weryfikacja z wykorzystaniem pliku w formacie RelaxNG:
echo '<p>Weryfikacja z wykorzystaniem formatu RelaxNG: ';
$pass = $dom->relaxNGValidate('contacts.rng');
echo $pass ? "Dokument zgodny z definicj.</p>\n" : "Dokument NIEZGODNY z definicj.</p>\n";

// Weryfikacja z wykorzystaniem pliku w formacie XML Schema:
echo '<p>Weryfikacja z wykorzystaniem formatu XML Schema: ';
$pass = $dom->schemaValidate('contacts.xsd');
echo $pass ? "Dokument zgodny z definicj.</p>\n" : "Dokument NIEZGODNY z definicj.</p>\n";

// Konwersja obiektu DOM na SimpleXML (w celu zaprezentowania moliwoci).
$xml = simplexml_import_dom($dom);
echo "<p>Nazwisko pierwszej osoby z pliku: {$xml->kontakt[0]->nazwisko}</p>\n";
?>

