<?php
// Odczytanie pliku XML do pamici z wykorzystaniem rozszerzenia SimpleXML.
$xml = simplexml_load_file('contacts.xml');

// Zastosowanie jzyka XPath do znalezienia wszystkich znacznikw 'meta' niezalenie od gbokoci.
$meta = $xml->xpath('//meta');

// Przetwarzanie wynikw w ptli i wywietlanie ich identyfikatorw.
foreach ($meta as $m) {
    echo "Meta - {$m['id']}<br />\n";
}

// Wyszukanie wszystkich znacznikw e-mail wystpujcych w obrbie znacznika kontakt, poczwszy od korzenia // dokumentu XML.
$email = $xml->xpath('/kontakty/kontakt/email');

// Przetwarzanie wynikw w ptli i wywietlanie adresw e-mail.
foreach ($email as $e) {
    echo "Email - {$e}<br />\n";
}

// Wyszukanie wszystkich kontaktw, dla ktrych podano numer telefonu komrkowego.
$cell = $xml->xpath('kontakt/telefon[@typ="komrkowy"]/..');

// Przetwarzanie wynikw w ptli i wywietlanie nazwisk osb.
foreach ($cell as $c) {
    echo "Kontakt z telefonem komrkowym - {$c->nazwisko}<br />\n";
}
?>
