<?php
// Wczenie biblioteki.
require_once 'mass_email.php';

// Utworzenie tablicy adresw e-mail subskrybentw.
$subscribers = array('przyklad@eliw.com', 'php@przyklad.com',
    'kusza@przyklad.com', 'eliwhite@przyklad.com',
    'ZygfrydFaust@przyklad.com', 'hyper@przyklad.com');

// Caa wiadomo e-mail (nagwek i tre) oczekuje
// jako strumie stdin. Wczytanie strumienia do pamici tak, by mona go byo przetworzy.
$msg = file_get_contents('php://stdin');

// Oddzielenie nagwka od treci. Aby znale granic, naley wyszuka
// pierwszy podwjny znak zakoczenia wiersza. W przypadku systemu Unix naley szuka cigu: \n\n.
//W systemie Windows kady znak przejcia do nowego wiersza to \r\n.
list($head, $body) = preg_split("/\n\n|[\r\n][\r\n][\r\n][\r\n]/", $msg, 2);

// Trzeba rozpozna kilka czci nagwka.
// W przypadku nagwka zoonego z kilku wierszy atwiej bdzie
// analizowa je osobno  w zwizku z tym podzielimy nagwek na poszczeglne wiersze.
$headlines = explode("\n", $head);

// Ustawienie wartoci domylnych w przypadku, gdyby nie dao si ich odczyta.
$from = 'listarodzinna@przyklad.com';
$subject = '[Bez tematu]';

// Przetwarzanie w ptli wszystkich wierszy nagwka. Zapisanie danych i zniszczenie wiersza.
foreach ($headlines as $key => $line) {
    // Jeli jest to wiersz 'from':
    if (strncasecmp($line, 'From:', 5) === 0) {
        //  odczytanie informacji o nadawcy i zapisanie jej:
        $from = trim(substr($line, 5));

        // Zniszczenie wiersza.
        unset($headlines[$key]);
    }
    // W przeciwnym razie, jeli jest to wiersz tematu (Subject):
    elseif (strncasecmp($line, 'Subject:', 8) === 0) {
        // odczytanie tematu.
        $subject = trim(substr($line, 8));

        // Zniszczenie wiersza.
        unset($headlines[$key]);
    }
}

// Odczytanie informacji w celu rozesania wiadomoci z niewielkimi zmianami do osb z listy.
// Nagwek 'From' pozostanie ten sam, ale warto Sender: ustawimy na adres listy,
// aby byo wiadomo, e wiadomo zostaa wysana na list (z listy).
// Ponadto dodamy prefiks do tematu, aby byo wiadomo, e pochodzi z listy.
// Pozostae nagwki pozostan bez zmian.

// Dodanie nagwka Sender:
$headlines[] = 'Sender: listarodzinna@przyklad.com';

// Wysanie wiadomoci do wszystkich osb wymienionych w tablicy!
mass_email($subscribers, $from, '[Rodzina] ' . $subject,
    $body, 'mail.przyklad.com',    implode("\n", $headlines) );
?>
