<?php
// Ustawienie strefy czasowej  funkcja mail() j wykorzystuje.
date_default_timezone_set('Europe/Warsaw');

//Funkcja, ktra pobiera argumenty w postaci tablicy adresw e-mail i wiadomoci do przesania,
// a nastpnie czy si z okrelonym serwerem SMTP w celu dostarczenia zawartoci.
function mass_email($emails, $from, $subj, $message,
        $smtp, $moreheaders = '') {
    // Najpierw naley nawiza poczenie z serwerem SMTP  port 25.
    if (!($sp = stream_socket_client("tcp://{$smtp}:25", $err_num,
            $err_string))) {
        exit("BD: Nieudana prba poczenia - {$err_num} - {$err_string}\n");
    }

    // Odczytanie odpowiedzi. Powitaniu powinna towarzyszy odpowied 220.
    _check_response(fgets($sp), '220');

    // Przesanie komunikatu HELO. Zwrmy uwag, e wykorzystano nazw
    // okrelonego serwera. W przypadku uruchomienia z wiersza polecenia taka nazwa
    // nie jest dostpna. Bdzie trzeba j okreli jawnie w nieco inny sposb:
    $host = isset($_SERVER['HTTP_HOST'])
        ? $_SERVER['HTTP_HOST'] : 'przyklad.com';
    fputs($sp, "HELO {$host}\n");

    // Sprawdzenie, czy serwer odpowiedzia, e wszystko przebiego poprawnie (odpowied 250).
    _check_response(fgets($sp), '250');

    // Pocztek ptli przesyania wiadomoci do poszczeglnych adresatw.
    foreach ($emails as $e) {
        // Ustawienie limitu 20 sekund na przesanie podanej wiadomoci.
        set_time_limit(20);

        // Informacja o nadawcy wiadomoci e-mail.
        fputs($sp, "MAIL FROM: {$from}\n");
        _check_response(fgets($sp), '250');

        // Informacja o adresacie wiadomoci e-mail.
        fputs($sp, "RCPT TO: {$e}\n");
        // W tym przypadku 'za' odpowied jest dobra. Oznacza ona, e serwer nie zaakceptowa
        // przekazanego adresu e-mail jako prawidowego. Pominicie odpowiedzi i kontynuowanie dziaania.
        if (_check_response(fgets($sp), '250', false)) {
            // Jeli skrypt doszed do tego miejsca, wszystko jest w porzdku. Przygotowanie treci.
            fputs($sp, "DATA\n");
            _check_response(fgets($sp), '354');

            // Wysanie nagwkw, wczenie parametru 'moreheaders', jeli go okrelono.
            fputs($sp, "To: {$e}\nFrom: {$from}\nSubject: " .
                "{$subj}\n{$moreheaders}\n\n");

            // Teraz mona przesa tre wiadomoci.
            fputs($sp, $message);

            // Indywidualna stopka.
            fputs($sp, "\n\n-- Wysano do: {$e} przez " .
                "Automat do wysyania poczt ksiki 'PHP 5 w praktyce'\n");

            // Zamknicie danych poprzez wprowadzenie wiersza zoonego z pojedynczej kropki.
            fputs($sp, ".\n");
            _check_response(fgets($sp), '250');
        } else {
            // Jeli skrypt trafi w to miejsce  odbiorca by nieprawidowy.
            //  Zresetowanie stanu serwera w celu ponownego rozpoczcia.
            fputs($sp, "RSET\n");
            _check_response(fgets($sp), '250');
        }
    }

    // Zamknicie poczenia  na tym koniec!
    fputs($sp, "QUIT\n");
    fclose($sp);

    // Przed zakoczeniem skryptu odtworzenie limitu czasowego do wartoci pierwotnej.
    set_time_limit(ini_get('max_execution_time'));
}

// Krtka funkcja narzdziowa wykorzystywana do sprawdzania odpowiedzi serwera.
// Funkcja porwnuje udzielon odpowied z odpowiedzi oczekiwan. Jeli argument bail
// ustawiono na true, wystpi bd krytyczny  wyjcie. W innym przypadku funkcja
//  zwraca false.
function _check_response($response, $expected, $bail = true) {
    // Porwnanie odpowiedzi z wartoci oczekiwan.
    if (strncmp($response, $expected, strlen($expected)) != 0) {
        // Jeli argument $bail ma warto true:
        if ($bail) {
            exit("BD: Nieprawidowa odpowied\nSpodziewana odpowied: {$expected}
Uzyskano: {$response}");
        } else {
            // Zwrcenie wartoci false, aby mona byo obsuy t sytuacj.
            return false;
        }
    }

    // Jeli skrypt doszed do tego miejsca, naley zwrci true.
    return true;
}
?>

