<?php
// Ustawienie strefy czasowej  funkcja mail() j wykorzystuje.
date_default_timezone_set('Europe/Warsaw');

// Zapisanie kilku wartoci do przesania poczt elektroniczn. Mog one pochodzi z dowolnego rda.
$to = 'example@eliw.com';
$subject = 'Przykadowa wiadomo e-mail - format podwjny z zacznikiem';

// Utworzenie cigu granicznego. Musi to by cig niepowtarzalny (nie moe si znale w tekcie),
// w zwizku z tym wykorzystamy algorytm sha1 w celu wygenerowania 40-znakowego cigu.
$sep = sha1(date('r', time()));

// Zdefiniowanie nagwkw do przesania.
$headers = "From: php@przyklad.com\r\nX-Mailer: Skrypt PHP";

// Dodanie podstawowej specyfikacji granicy treci (boundary) i typu mime.
$headers .=
    "\r\nContent-Type: multipart/alternative; boundary=\"PHP-alt-{$sep}\"";

// Odczytanie pliku zacznika.
$attachment = file_get_contents('attachment.zip');

// Zakodowanie zawartoci pliku do postaci base64, tak by mona byo bezpiecznie przesya pliki binarne
// poczt elektroniczn wykorzystujc tekstowy protok.
$encoded = base64_encode($attachment);

// Wykorzystanie funkcji chunk_split w celu automatycznego podziau treci na wiersze o dugoci
// co najwyej 76 znakw. Jest to konieczne, by speni warunki protokou e-mail.
$attached = chunk_split($encoded);

// Teraz tre wiadomoci. Kad podstawow cz (wiadomo i zaczniki) naley oddzieli
// za pomoc pierwszego separatora. Nastpnie w obrbie kadej czci naley oddzieli
// alternatywne wersje za pomoc drugiego separatora.
$body =<<<EOBODY
--PHP-mixed-{$sep}
Content-Type: multipart/alternative; boundary="PHP-alt-{$sep}"

--PHP-alt-{$sep}
Content-Type: text/plain

To jest przykadowa wiadomo e-mail.

Witaj, wiecie!

To by byo na razie tyle.

--PHP-alt-{$sep}
Content-Type: text/html

<p>To jest przykadowa wiadomo e-mail</p>
<h2>Witaj, wiecie!</h2>
<p>To by byo na razie tyle.</p>

--PHP-alt-{$sep}--

--PHP-mixed-{$sep}
Content-Type: application/zip; name="attachment.zip"
Content-Transfer-Encoding: base64
Content-Disposition: attachment

{$attached}
--PHP-mixed-{$sep}--
EOBODY;

// Na koniec przesyamy wiadomo e-mail.
mail($to, $subject, $body, $headers);
?>
