<?php
// Prosty serwer WWW napisany w PHP.

// Podstawowa konfiguracja na pocztku pliku
// umoliwiajca atw edycj.
$port = 8088;
$host = '127.0.0.1';
$docroot = '/html';

// Dziki temu ustawieniu nigdy nie nastpi przekroczenie limitu czasu.
set_time_limit(0);

// Nasuchiwanie wyznaczonego portu.
if (!($server = stream_socket_server("tcp://{$host}:{$port}",
        $err_num, $err_string))) {
    exit("BD: Nieudane otwarcie serwera - {$err_num} - {$err_string}\n");
}

// Pocztek ptli nieskoczonej.
for (;;) {
    // Nasuchiwanie kolejnego poczenia  bez limitu czasu:
    $client = stream_socket_accept($server, -1);

    // Jeli uzyskano poczenie z klientem, a nie bd:
    if ($client) {
        // Prba utworzenia nowego procesu, tak by serwer
        // w dalszym cigu mg akceptowa nowe poczenia.
        $pid = pcntl_fork();

        // Jeli wystpi bd:
        if ($pid == -1) {
            exit("BD: Nie mona utworzy nowego procesu!");
        }
        // W innym przypadku, jeli biecy proces to proces potomny:
        elseif (!$pid) {
            // Odczytanie pierwszego wiersza dania
            // (jedyny wiersz, ktrym bdziemy si zajmowa).
            $command = fgets($client, 2048);

            // Odczytanie pozostaej czci dania, ktre jednak bdzie zignorowane,
            // poniewa jest to bardzo prosty serwer WWW. Naley odczyta
            // wszystkie wiersze w daniu, do czasu odczytania pustego wiersza lub
            // komunikatu o bdzie. Oznacza to, e danie obsuono.
            while($line = fgets($client, 2048)) {
                if (trim($line) === '') { break; }
            }

            // Podzia cigu dania na czci.
            $request = explode(' ', $command);

            // Jeli danie nie jest typu GET, poinformowanie uytkownikw o braku moliwoci jego obsugi.
            if ($request[0] != 'GET') {
                // Odpowied z informacj o braku implementacji.
                @fwrite($client,
"HTTP/0.9 501 Wasno niezaimplementowana
Server: Prosty-SerwerWWW-wPHP
Content-Type: text/html

<html><head><title>501 Wasno niezaimplementowana</title></head>
<body><h1>501 Wasno niezaimplementowana</h1>
<p>To bardzo prosty serwer WWW, w ktrym zaimplementowano tylko dania GET</p>
</body></html>");
                // Zamknicie poczenia.
                fclose($client);
                // Zakoczenie dziaania procesu potomnego
                exit();
            }

            // Prba rozdzielenia parametrw GET uytych w daniu.
            $parts = explode('?', $request[1]);

            // Jeli danie koczy si znakiem '/', zakadamy, e jest to index.php.
            if ($parts[0]{strlen($parts[0])-1} == '/') {
                $parts[0] .= 'index.php';
            }

            // Jeli danego pliku nie mona znale w gwnym katalogu dokumentw:
            if (!is_file($docroot . $parts[0])) {
                // Odpowied z kodem bdu 404  nie mona znale dokumentu.
                @fwrite($client,
"HTTP/0.9 404 Pliku nie znaleziono
Server: Prosty-SerwerWWW-wPHP
Content-Type: text/html

<html><head><title>404 Pliku nie znaleziono</title></head>
<body><h1>404 Pliku nie znaleziono</h1>
<p>danego pliku nie znaleziono na serwerze!</p>
</body></html>");
                //Zamknicie poczenia.
                fclose($client);
                // Zakoczenie dziaania procesu potomnego.
                exit();
            }

            // To ju PRAWIE koniec.
            // Naley tylko wybra typ pliku, ktry ma by zwrcony.
            $path = pathinfo($parts[0]);
            switch ($path['extension']) {
                // Pliki graficzne.
                case 'gif':
                case 'png':
                case 'jpg':
                    $mime = "image/{$path['extension']}";
                    break;
                // Pliki tekstowe. 
                case 'html':
                case 'xml':
                case 'css':
                    $mime = "text/{$path['extension']}";
                    break;
                // JavaScript.
                case 'js':
                    $mime = 'application/x-javascript';
                    break;
                // Specjalny przypadek dla plikw PHP.
                case 'php':
                    $mime = 'text/html';
                    break;
                // Oglna odpowied dla plikw wszystkich pozostaych typw.
                default:
                    $mime = 'application/octet-stream';
            }

            // Wiemy, jaki typ mime naley zwrci. Przygotowanie zmiennych GET.
            if (isset($parts[1])) {
                // Umieszczenie parametrw w tablicy $_GET tak samo, jak robi to interpreter PHP.
                parse_str($parts[1], $_GET);
            }

            // WCZENIE pliku, niezalenie od typu. To jest
            //  serwer WWW z obsug PHP, zatem zakadamy, e w KADYM
            // pliku moe si znajdowa osadzony kod PHP. Przechwycenie wyniku
            // za pomoc buforowania
            ob_start();
            include "{$docroot}{$parts[0]}";
            $output = ob_get_contents();
            ob_end_clean();

            // Czas na zwrcenie treci!
            $length = strlen($output);
            @fwrite($client,
"HTTP/0.9 200 Ok
Server: Prosty-SerwerWWW-wPHP
Content-Type: {$mime}
Content-Length: {$length}

{$output}");

            // Poniewa nie obsugujemy nagwka Keep-Alive, zamykamy poczenie.
            fclose($client);
            exit();
        }
    }
    // W tym miejscu wykonuje si proces nadrzdny, Przed ponown iteracj ptli naley si upewni,
    //  e proces nadrzdny zamkn poczenie z klientem.
    @fclose($client);
}
?>
