<?php
// Prosty klient FTP.

// Przygotowanie do operacji odczytu ze standardowego urzdzenia wejciowego.
$stdin = fopen('php://stdin', 'r');
$server = false;
$mode = FTP_ASCII;

// Deklaracja dostpnych polece.
$commands = array('open', 'close', 'quit', 'exit', 'cd', 'ls', 'dir',
    'pwd', 'get', 'put', 'ascii', 'binary', 'bin', 'delete', 'del');

// Jeli podano parametry, zakadamy, e opisuj hosta, uytkownika i haso.
if ($argc > 1) {
    // Usunicie nazwy pliku z adresu URL.
    array_shift($argv);
    // Wywoanie funkcji open w celu obsugi poczenia.
    _open($argv);
}

// Ptla pobierajca dane wejciowe od uytkownika i obsugujca je.
while (true) {
    // Wywietlenie symbolu zachty.
    echo 'phpftp> ';

    // Pobranie danych wejciowych od uytkownika.
    $line = trim(fgets($stdin));

    // Kontynuacja tylko wtedy, gdy pobrano jakie dane.
    if ($line) {
        // Podzia wiersza na tablic elementw rozdzielonych spacjami.
        $opts = explode(' ', $line);
        $cmd = strtolower(array_shift($opts));

        // Pobranie pierwszego elementu jako polecenia i wywoanie odpowiedniej
        //  funkcji. Najpierw trzeba si jednak upewni, e jest to prawidowe polecenie!
        if (!in_array($cmd, $commands)) {
            echo "! Polecenie nieobsugiwane.\n";
        }
        // Jeli zmienna $server ma warto false, jedynym dozwolonym poleceniem jest 'open'.
        // W innym przypadku polecenie open jest niedozwolone.
        elseif (($server xor ($cmd != 'open')) && ($cmd != 'quit')
                && ($cmd != 'exit')) {
            echo "! Nieprawidowy status serwera dla tego polecenia.\n";
        } else {
            // W innym przypadku mona uruchomi dowolne polecenie.
            // Wystarczy wywoa je jako nazw funkcji, jeli w tym momencie istnieje!
            $func = "_{$cmd}";
            $func($opts);
        }
    }
}

// Deklaracja funkcji dla poszczeglnych polece!

// Otwarcie poczenia.
function _open($opts) {
    global $server, $stdin;

    // Przygotowanie do otwarcia poczenia. Wywietlenie pytania o brakujce elementy, na przykad nazw hosta.
    if (!isset($opts[0])) {
        echo '? Host: ';
        $opts[0] = trim(fgets($stdin));
    }

    // Nazwa uytkownika.
    if (!isset($opts[1])) {
        echo '? Uytkownik: ';
        $opts[1] = trim(fgets($stdin));
    }

    // I na koniec haso. Zwrmy uwag, e haso bdzie widoczne na ekranie.
    if (!isset($opts[2])) {
        echo '? Haso: ';
        $opts[2] = trim(fgets($stdin));
    }

    // Mamy teraz wszystkie potrzebne argumenty. Prba nawizania poczenia!
    if (!($server = @ftp_connect($opts[0]))) {
        echo "! Bd, nie mona nawiza poczenia z hostem!\n";
        $server = false;
    } else {
        // Udao si nawiza poczenie. Prba logowania.
        if (!(@ftp_login($server, $opts[1], $opts[2]))) {
            echo "! Bd, nazwa uytkownika lub haso s nieprawidowe!\n";
            ftp_close($server);
            $server = false;
        } else {
            // Wszystko dziaa. Poinformowanie uytkownikw!
            echo "- Nawizano poczenie z {$opts[0]}\n";

            // Prba wywietlenia rwnie typu serwera.
            if ($type = ftp_systype($server)) {
                echo "- Typ serwera: {$type}\n";
            }

            // Ustawienie trybu na ASCII i wywietlenie uytkownikom
            //  informacji o przegldanym katalogu:
            _ascii(0);
            _pwd(0);
        }
    }
}

// Funkcja zamykajca poczenie:
function _close($opts) {
    @ftp_close($GLOBALS['server']);
    $GLOBALS['server'] = false;
    echo "- Poczenie zamknito.\n";
}

// Zmiana katalogu.
function _cd($opts) {
    // Prba zmiany katalogu na katalog okrelony za pomoc argumentu.
    if (!(@ftp_chdir($GLOBALS['server'], @$opts[0]))) {
        echo "! Bd! Nieudana prba zmiany katalogu\n";
    }

    // Wywietlenie uytkownikom informacji o biecym katalogu.
    _pwd(0);
}

// Wyjcie z programu!
function _exit($opts) {
    // Zamknicie poczenia, jeli jest aktywne.
    if ($GLOBALS['server']) {
        _close(0);
    }
    echo "- Do zobaczenia!\n";
    exit();
}
function _quit($opts) {
    _exit($opts);
}

// Pobranie zawartoci katalogu.
function _ls($opts) {
    // Uycie funkcji ftp_rawlist w celu uzyskania sformatowanej wersji listingu z serwera.
    // Przekazanie opcji za pomoc jednego cigu znakw.
    $optstring = implode(' ', $opts);
    if ($res = ftp_rawlist($GLOBALS['server'], $optstring)) {
        foreach ($res as $r) { echo "{$r}\n"; }
    } else {
        // Wywietlenie komunikatu o bdzie.
        echo "! Bd! Nie mona wygenerowa listingu katalogu\n";
    }
}
function _dir($opts) {
    _ls($opts);
}

// Funkcja sprawdzajca biecy katalog uytkownika.
function _pwd($opts) {
    // Odczytanie biecego katalogu i wywietlenie go.
    $cwd = ftp_pwd($GLOBALS['server']);
    echo "- Biecy katalog: {$cwd}\n";
}

// Funkcja pobierajca plik ze zdalnego hosta i zapisujca go w lokalnym systemie plikw.
function _get($opts) {
    // Wywietlenie komunikatu o bdzie, jeli nie wprowadzono adnych opcji.
    if (!($opts)) {
        echo "! Bd! Nie okrelono pliku.\n";
    } else {
        // Jeli nie wprowadzono drugiej opcji, zakadamy, e uytkownik zamierza
        // zapisa plik w biecym katalogu, nadajc mu t sam nazw.
        if (!isset($opts[1])) {
            $opts[1] = basename($opts[0]);
        }

        // Prba zapisania pliku.
        if (!@ftp_get($GLOBALS['server'], $opts[1], $opts[0],
                $GLOBALS['mode'])) {
            echo "! Bd! - Nie mona pobra pliku.\n";
        } else {
            echo "- Dane zapisano w pliku: {$opts[1]}\n";
        }
    }
}

// Funkcja zapisujca lokalny plik na zdalnym hocie.
function _put($opts) {
    // Wywietlenie komunikatu o bdzie, jeli nie wprowadzono adnych opcji.
    if (!($opts)) {
        echo "! Bd! Nie okrelono pliku.\n";
    } else {
        // Jeli nie wprowadzono drugiej opcji, zakadamy, e uytkownik zamierza
        // zapisa plik w biecym katalogu, nadajc mu t sam nazw.
        if (!isset($opts[1])) {
            $opts[1] = basename($opts[0]);
        }

        // Prba zapisania pliku.
        if (!@ftp_put($GLOBALS['server'], $opts[1], $opts[0],
                $GLOBALS['mode'])) {
            echo "! Bd! - Nie mona przesa pliku.\n";
        } else {
            echo "- Dane zapisano w pliku: {$opts[1]}\n";
        }
    }
}

// Funkcja zmieniajca tryb przesyania na ASCII.
function _ascii($opts) {
    // Zmiana trybu przesyania i wywietlenie informacji.
    $GLOBALS['mode'] = FTP_ASCII;
    echo "- Tryb przesyania: ASCII\n";
}

// Funkcja zmieniajca tryb przesyania na binarny.
function _binary($opts) {
    // Zmiana trybu przesyania i wywietlenie informacji.
    $GLOBALS['mode'] = FTP_BINARY;
    echo "- Tryb przesyania: Binarny\n";
}
function _bin($opts) {
    _binary($opts);
}

// Funkcja umoliwiajca usuwanie plikw.
function _delete($opts) {
    // Wywietlenie komunikatu o bdzie, jeli nie wprowadzono adnych opcji.
    if (!($opts)) {
        echo "! Bd! Nie okrelono pliku.\n";
    } else {
        // Prba usunicia pliku.
        if (!@ftp_delete($GLOBALS['server'], $opts[0])) {
            echo "! Bd! - Nie mona usun pliku.\n";
        } else {
            echo "- Plik usunito: {$opts[0]}\n";
        }
    }
}
function _delete($opts) {
    function _delete($opts) {
}
?>
