<?php
// Deklarujemy podstawowe zmienne.
$matches = array();
$names = array();

// Otwieramy nasz plik dziennika w trybie odczytu.
if (!($fp = @fopen('access.log', 'r'))) {
   die("Brak dostpu do pliku dziennika!");
}

// Odczytujemy zawarto dziennika linijka po linijce.
while ($logline = fgets($fp)) {
   // Analiza pojedynczej linii.
   if (preg_match('/^(\S+) (\S+) (\S+) \[([^\]]+)\] "([^"]+)" (\S+)' .
     ' (\S+) "([^"]*)" "([^"]*)"$/', $logline, $matches)) {
      // Zapisujemy typ przegldarki i przygotowujemy miejsce na informacje o systemie operacyjnym.
      $agent = $matches[9];
      $ostype = '';

      // Szukamy cigw znakw opisujcych rodzaj systemu operacyjnego.
      if (strpos($agent, 'Win') !== false) { $ostype = 'Windows'; }
      elseif (strpos($agent, 'Mac') != false) { $ostype = 'Macintosh'; }
      elseif (preg_match('/X11|Linux/', $agent)) { $ostype = 'Unix'; }
      else { $ostype = 'Inny system operacyjny'; }

      // Ponownie przeszukujemy dane, szukajc rodzaju klienta, z ktrego korzysta uytkownik.
      // Wana jest kolejno poniszych operacji, poniewa zostay posegregowane tak, aby uzyska
      //  moliwie najkrtszy czas porwna.
      $results = array();

      // Szukamy IE.
      if (preg_match('/MSIE ([0-9.]+)/', $agent, $results)) {
         @$names["IE {$results[1]} - $ostype"]['count']++;
      // Safari.
      } elseif (preg_match('/Safari\/([0-9.]+)/', $agent, $results)) {
         @$names["Safari {$results[1]}"]['count']++;
         @$names["Safari {$results[1]}"]['subs'][$ostype]++;
      // Konqueror.
      } elseif (preg_match('/Konqueror\/([0-9.]+)/', $agent, $results)) {
         @$names["Konqueror {$results[1]}"]['count']++;
         @$names["Konqueror {$results[1]}"]['subs'][$ostype]++;
      // Opera.
      } elseif (preg_match('/Opera\/?([0-9.]+)/', $agent, $results)) {
         @$names["Opera {$results[1]}"]['count']++;
         @$names["Opera {$results[1]}"]['subs'][$ostype]++;
      // Nowe przegldarki z rodziny Mozilla.
      } elseif (preg_match('/rv:([a-z0-9.]+)/', $agent, $spec)) {
         @$names["Mozilla {$results[1]}"]['count']++;
         // Sprawdzamy, jaka to wersja Mozilli.
         $spec = array();
         if (preg_match('/Netscape6?\/([0-9.]+)/', $agent, $spec)) {
            @$names["Mozilla {$results[1]}"]['subs']
              ["Netscape {$spec[1]} - {$ostype}"]++;
         } elseif (preg_match('/(?:Firefox|Firebird|Phoenix)\/([0-9.]+)/',
           $agent, $spec)) {
            @$names["Mozilla {$results[1]}"][ 'subs']
              ["Firefox {$spec[1]} - {$ostype}"]++;
         } else {
            @$names["Mozilla {$results[1]}"][ 'subs']
              ["Mozilla {$spec[1]} - {$ostype}"]++;
         }
      // Starsze wersje Netscape.
      } elseif (preg_match('/Mozilla\/([0-9.]+)/', $agent, $results)) {
         @$names["Netscape {$results[1]}"]['count']++;
         @$names["Netscape {$results[1]}"]['subs'][$ostype]++;
      // Inne aplikacje niebdce przegldarkami.
      } elseif (preg_match('/[Gg]oogle|Java|msn/', $agent)) {
         @$names['Klient nie jest przegldark']['count']++;
      // Wszytkie pozostae oznaczymy jako inne.
      } else {
         @$names['Inne przegldarki']['count']++;
         @$names['Inne przegldarki']['subs'][$ostype]++;
      }
   }
}

// Zamykamy plik dziennika, z ktrego korzystalimy.
fclose($fp);

// Zanim zaczniemy wywietla jakie informacje, przygotujmy wszystkie dane.
// Najpierw zsumujemy wszystkie wyniki.
$total = 0;
foreach ($names as $one => $val) { $total += $val['count']; }

// Sortujemy je pod wzgldem liczby trafie.
function compare($a, $b) {
   if ($a['count'] == $b['count']) { return 0; }
   else return (($a['count'] < $b['count']) ? 1 : -1);
}
uasort($names, 'compare');

// Tu zaczyna si waciwa strona.
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><title>Statystyki przegldarek</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<style>
body {
   font-family: Geneva, Arial, Sans Serif;
   background-color: #ECECEC;
   text-align: center;
   font-size: 11px;
}
table { border: 2px solid black; }
th, td {
   border: 1px solid black;
   padding: 1px;
   margin: 1px;
}
td { text-align: right; }
.sm { font-size: 10px; }
.name { text-align: left; }
table.sub {
   background-color: #E0E0E0;
   margin-left: 10px;
}
</style>
</head>
<body>
<h1>Statystyki przegldarek</h1>
<table><tr>
<th scope="col" width="1%" style="background-color: #999999">Lp.</th>
<th scope="col" colspan="2" style="background-color: #CCCC00">Liczba trafie</th>
<th scope="col" style="background-color: #9999FF">Przegldarka</th>
<th scope="col" style="background-color: #CC00CC">Suma</th>
</tr><tr><td colspan="5"></td></tr>
<?php
// Przedstawiamy wszystkie dane.
$count = 1;
$cuml = 0;
foreach ($names as $one => $val) {
   // Liczba porzdkowa.
   echo '<tr><th scope="row">', $count++, "</th>\n";
   // Ilo.
   echo "<td>{$val['count']}</td>\n";
   $cuml += $val['count'];
   // Procent.
   printf("<td> &nbsp;%.2f%%</td>\n", 100.00 * ($val['count'] / $total));
   // Nazwa.
   echo "<td class=\"name\"> &nbsp;{$one}";

   // Jeli ma informacje dodatkowe
   if (isset($val['subs'])) {
      // Wywietlamy je.
      echo "<table class=\"sub sm\">\n";

      // Sortujemy.
      arsort($val['subs']);
      foreach ($val['subs'] as $sb => $sbnum) {
         // Trafienia.
         echo "<tr><td> &nbsp;{$sbnum}</td>\n";
         // Procent.
         printf("<td class=\"sm2\"> &nbsp;%.2f%%</td>\n",
           100.00 * ($sbnum / $val['count']));
         // Nazwa.
         echo "<td class=\"name\"> &nbsp;{$sb}</td>\n";
         echo "</tr>\n";
      }
      echo "</table>";
   }
   // Zamykamy komrk z nazw.
   echo "</td>\n";

   // Wyliczamy procent z caoci.
   printf("<td> &nbsp;%.2f%%</td>\n", 100.00 * ($cuml / $total));
   print "</tr>\n";
}

// Zamykamy wszystkie znaczniki.
?>
</table>
</body>
</html>
