<?php
// Biblioteka umoliwiajca przekazywanie danych z sesji midzy dwoma serwerami o tej samej poddomenie.

// Funkcja umieszczajca dane z sesji w pliku cookie.
function session_2_cookie() {
   // Dane z sesji nalezy uporzdkowa i zakodowa do base64.
   $output = base64_encode(serialize($_SESSION));

   // Nastpnie naley je rozesa w caej domenie jako plik cookie.
   setcookie('sessionpass', $output, false, '/', garner_subdomain());
}

// Funkcja, ktra tworzy now sesj na podstawie otrzymanego pliku cookie.
function cookie_2_session() {
   // Upewniamy si, e zainicjowano now sesj.
   @session_start();

   // Odkodowujemy dane z pliku cookie i zapisujemy w tablicy $_SESSION.
   $_SESSION = unserialize(base64_decode(@$_COOKIE['sessionpass']));
}

// Dodatkowa funkcja, ktra pozwoli na automatyczne okrelenie poddomeny.
function garner_subdomain() {
   // Dzielimy adres serwera na czci.
   $parts = explode('.', $_SERVER['HTTP_HOST']);
   $cp = count($parts);

   // Jeli adres serwera jest jednoczonowy, p.. localhost, pomijamy go.
   if ($cp == 1) { $subdomain = ''; }
   // W innym przypadku skrypt generuje subdomen z ostatnich dwch czci.
   else { $subdomain = ".{$parts[$cp-2]}.{$parts[$cp-1]}"; }

   return $subdomain;
}

// Szybki test.
// Jeli nie zostaa pobrana warto metod GET, tworzymy pust sesj i nadajemy odpowiednie wartoci.
if (!(isset($_GET['next']))) {
   // Tworzymy now sesj.
   session_start();

   // Usuwamy wszystkie wartoci.
   $_SESSION = array();

   // Dodajemy pojedyncz warto.
   $_SESSION['test'] = 'Witaj, wiecie!';

   // Zamieniamy sesj w plik cookie.
   session_2_cookie();

   // Na potrzeby testu robimy przekierowanie na t sam stron.
   header("Location: {$_SERVER['PHP_SELF']}?next=true");
} else {
   // Udajc, e zostalimy przekierowani z innego serwera, moemy zamieni plik cookie w now sesj.
   cookie_2_session();
   // Wywietlamu wartoci sesji.
   echo "<p>{$_SESSION['test']}</p>";
}
?>
