<?php
// Strona pokazujca zawarto koszyka.
session_start();

// Doczamy nasz bibliotek produktw.
require 'products.php';

// Jeli uytkownik zada usunicia caej zawartoci koszyka, robimy to.
if (@$_POST['submit'] == 'Oprnij koszyk') {
   unset($_SESSION['cart']);
}
// W innym przypadku sprawdzamy, czy nie dokona zmian w jego zawartoci.
elseif (isset($_POST['update'])) {
   // Szukamy wszystkich zmian.
   foreach ($_POST['update'] as $id => $val) {
      // Interesuj nas tylko zmienne niemajce przypisanych adnych wartoci lub wartoci liczbowe.
      $val = trim($val);
      if (preg_match('/^[0-9]*$/', $val)) {
         // Zmienne pozbawione wartoci lub rwne 0 uwuwamy.
         if ($val == 0) {
             unset($_SESSION['cart'][$id]);
         } else {
            // Pozostaym nadajemy nowe wartoci.
            $_SESSION['cart'][$id] = $val;
         }
      }
   }
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><title>Twj koszyk</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<style>
table { border-collapse: collapse; }
.num { text-align: right; }
td, th, div { border: 1px solid black; padding: 4px; }
</style>
</head>
<body>
<p>Twj koszyk zawiera:</p>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post">
<table>
  <tr><th scope"col">Produkt</th><th scope="col">Nazwa</th>
  <th scope="col">Cena</th><th scope="col">Ilo</th></tr>
<?php
// Wczytujemy produkty znajdujce si w koszyku.
$counter = 0;
$total = 0;
if (@is_array($_SESSION['cart'])) {
   foreach ($_SESSION['cart'] as $id => $c) {
   // Wypeniamy komrki wiersza.
   $counter++;
   echo "<tr><td>{$counter}</td><td>{$products[$id]['desc']}</td>",
      "<td class=\"num\">", number_format($products[$id]['price'],2),
      "</td><td><input type=\"text\" size=\"3\" class=\"num\" ",
      "name=\"update[{$id}]\" value=\"{$c}\" /></td></tr>\n";

   // Obliczamy czn kwot.
   $total += $products[$id]['price'] * $c;
   }
}

// Dodajemy informacj o liczbie produktw w koszyku, opcje edycji danych i potwierdzenia zakupu.
// Uwaga! W tym przykadzie przycisk Kup teraz nie ma adnego zastosowania.
?>
<tr class="num"><td colspan="3">czna kwota:</td>
  <td><?= number_format($total,2) ?></td></tr>
<tr class="num"><td colspan="4">
<input type="button" value="Kontynuuj zakupy"
  onclick="javascript:window.location.href='view.php'" />
<input type="submit" name="submit" value="Zmie ilo" />
<input type="submit" name="submit" value="Oprnij koszyk"
  onclick="return.confirm('Na pewno oprni koszyk?')" />
<input type="button" value="Kup teraz" />
</td></tr>
</table>
</form>
</body>
</html>
