<?php
// Nasza strona z opisami.
// Wywietlimy wszystkie dostpne produkty i pozwolimy klientom je wybra.
session_start();

// Doczamy nasz bibliotek produktw.
require 'products.php';

// Sprawdzamy, czy uytkownik doda co do koszyka.
if (isset($_GET['add'])) {
   @$_SESSION['cart'][$_GET['add']]++;
}

// Podliczamy, ile przedmiotw znajduje si w koszyku i jaka jest ich czna warto.
$total_num = 0;
$total_value = 0;
if (isset($_SESSION['cart'])) {
   foreach (@$_SESSION['cart'] as $id => $count) {
      $total_value += $products[$id]['price'] * $count;
      $total_num += $count;
   }
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><title>Lista produktw</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<style>
table { border-collapse: collapse; }
.num { text-align: right; }
#cart { float: right; text-align: center; }
td, th, div { border: 1px solid black; padding: 4px; }
.button {
   display: block; padding: 2px 5px; background-color: #0000FF;
   color: white; text-decoration: none;
   border-style: solid; border-width: 4px;
   border-bottom-color: #000099; border-right-color: #000099;
   border-top-color: #0066FF; border-left-color: #0066FF;
}
</style>
</head>
<body>
<div id="cart">Ilo przedmiotw w koszyku: <?= $total_num ?>
<br />czna warto przedmiotw w koszyku: <?= $total_value ?>
<br /><a href="cart.php">Zobacz zawarto koszyka</a>
</div>
<p>Prosz wybra produkty, ktre chcieliby Pastwo zamwi:</p>
<table>
 <tr><th scope="col">Lp.</th><th scope="col">Nazwa produktu</th>
 <th scope="col">Cena</th><th scope="col">Kup teraz!</th></tr>
<?php
// Wczytujemy nasze produkty.
$counter = 0;
foreach ($products as $id => $p) {
   // Wypeniamy komrki wiersza.
   $counter++;
   echo "<tr><td>{$counter}</td><td>{$p['desc']}</td><td class=\"num\">",
      number_format($p['price'],2), "</td>";
   // Na kocu kadego wiersza umieszczamy przycisk Dodaj do koszyka.
   echo "<td><a class=\"button\"
  href=\"{$_SERVER['PHP_SELF']}?add={$id}\">Dodaj do koszyka</a></td></tr>\n";
}
?>
</table>
</body>
</html>

