<?php
// Ten skrypt wykonuje trzy funkcje na podstawie danych wejciowych.
// Jeli stwierdzi, e przegldarka obsuguje cookies, wywietli odpowiedni komentarz.
// Jeli odczyta jakie dane wysane metod POST, zapisze je w pliku cookie i wywietli ten sam komentarz.
// Jeli nie nastpi adna z powyszych sytuacji, wywietli si formularz wprowadzania danych.

// Sprawdzamy, czy mamy dane, ktre nas interesuj:
if (isset($_COOKIE['firstname']) && isset($COOKIE['zipcode'])) {
   // Znalelimy cookies, wic wystarczy wywietli komentarz.
   print_standard_output($_COOKIE['firstname'], $_COOKIE['zipcode']);
}
// Jeli otrzymalimy dane z formularza metod POST:
elseif (isset($_POST['firstname']) && isset($_POST['zipcode'])) {
   // Najpierw zamienimy je na cookies. Utworzymy cookie o nazwie firstname, ktre zostanie 
   // usunite po zamkniciu przegldarki i odesane tylko do tego podkatalogu.
   setcookie('firstname', $_POST['firstname']);

   // Niech skrypt sam okreli subdomen.
   $parts = explode('.', $_SERVER['HTTP_HOST']);
   $cp = count($parts);
   // Jeli adres serwera jest jednoczonowy, np localhost, pomijamy go.
   if ($cp == 1) { $subdomain = ''; }
   // W innym przypadku skrypt wygeneruje subdomen z ostatnich dwch czci.
   else { $subdomain = '.{$parts[$cp-2]}.{$parts[$cp-1]}'; }

   // Teraz utworzymy plik 'zipcode', ktry bdzie zwracany do caej subdomeny (caej strony),
   //  i ktry zachowa wano przez najblisze 30 dni.
   setcookie('zipcode', $_POST['zipcode'], time()+(30*24*3600), '/', $subdomain);

   // Teraz take moemy wywietli standardowy komentarz.
   print_standard_output($_POST['firstname'], $_POST['zipcode']);
}
// Nie mielimy adnych danych, stwrzmy wic formularz do ich wpisania.
else {
   echo "
<form action=\"{$_SERVER['PHP_SELF']}\" method=\"POST\">
<p>Jak masz na imi? <input type=\"text\" name=\"firstname\" /></p>
<p>Podaj nazw swojej miejscowoci: <input type=\"text\" name=\"zipcode\" /></p>
<p><input type=\"submit\" /></p>
</form>
";
}

// Standardowy komentarz.
function print_standard_output($name, $zip) {
   echo "
<p>Witaj ponownie {$name}! Czy chcesz dowiedzie si,
  co nowego zdarzyo si w Twojej miejscowoci ({$zip})?</p>
";
}
?>
