<?php
// Funkcja sprawdzajca poprawno adresw URL. Poniewa zakadamy, e
// adres zosta wprowadzony przez uytkownika, bdziemy wymaga, aby by to
// bezwzgldny adres URL, a nie adres wzgldny.
function validate_url($url) {
    // Wykorzystanie funkcji parse_url w celu podziau adresu URL na czci skadowe.
    $up = parse_url($url);

    // Jeli schemat, host lub cieka nie istniej  adres jest NIEPRAWIDOWY.
    if (!$up || !$up['scheme'] || !$up['host'] || !$up['path']) {
        return false;
    }

    // Jeli schemat to cokolwiek innego ni http(s) lub ftp, adres jest nieprawidowy.
    if (!( ($up['scheme'] == 'http') ||
           ($up['scheme'] == 'https') ||
           ($up['scheme'] == 'ftp'))  ) {
        return false;
    }

    // Poniewa skrypt doszed do tego miejsca, mona uzna, e adres ma prawidowy format.
    return true;
}

// Funkcja, ktra pobiera adres url i prbuje nawiza poczenie z serwerem.
// W przypadku braku dostpu do zdalnego pliku funkcja zwraca false, w przeciwnym razie  true.
function check_url($url) {
    // Zadanie tylko nagwkw  pobieranie caego pliku nie ma sensu.
    // Naley zwrci uwag, e wywoanie to bdzie mogo obsugiwa poczenia https, jeli PHP
    // skompilowano z obsug SSL.
    $output = @get_headers($url);

    // Zwrcenie wyniku.
    return $output ? true : false;
}

// Przetestowanie kilku adresw URL.
$urls = array('http://eliw.com/', 'http://php.net/get_headers',
    'gopher://bob.com/', 'https://lawn.tractor/models/1.php',
    'http://hubblesite.org/news/2006/01/', 'http://digg.com/');

// Przetwarzanie w ptli podanych adresw. Sprawdzenie, czy maj poprawny format. Jeli tak  prba 
// nawizania poczenia.
foreach ($urls as $r) {
    // Jeli format adresu nie jest prawidowy:
    if (!(validate_url($r))) {
        // Przygotowanie do wywietlenia wyniku.
        $disp = 'ma nieprawidowy format!';
    } else {
        // Prba dostpu do adresu i przygotowanie do wywietlenia wyniku..
        $disp = check_url($r) ? 'DOBRY!' : 'Nie odpowiada...';
    }

    // Wywietlenie wyniku.
    echo "<p>{$r} = {$disp}</p>\n";
}
?>

