<?php
// Funkcja pobiera cig znakw i poddaje standaryzacji numery kart kredytowych.
function standardize_credit($num) {
    // Usunicie z cigu wszystkich znakw, ktre nie s cyframi.
    return preg_replace('/[^0-9]/', '', $num);
}

// Funkcja sprawdzajca poprawno numeru karty kredytowej.
// Naley do niej przekaza parametry w postaci numeru oraz
// znaku oznaczajcego typ karty kredytowej:
// m = Mastercard, v = Visa, d = Discover, a = American Express.
function validate_credit($num, $type) {
    // Wykonanie testw na poprawno specyficznych typw kart.
    // Zapamitanie kilku parametrw, ktre bd czsto potrzebne.
    $len = strlen($num);
    $d2 = substr($num,0,2);

    // Numer karty Visa musi rozpoczyna si od cyfry 4 i skada si z 13 lub 16 cyfr.
    if ( (($type == 'v') && (($num{0} != 4) ||
                !(($len == 13) || ($len == 16)))) ||
    // Numer karty Mastercard rozpoczyna si od 51-56 i ma dugo 16 cyfr.
         (($type == 'm') && (($d2 < 51) ||
                 ($d2 > 56) || ($len != 16))) ||
    // Numery kart American Express rozpoczynaj si od liczb 34 lub 37  s 15-cyfrowe.
         (($type == 'a') && (!(($d2 == 34) ||
                 ($d2 == 37)) || ($len != 15))) ||
    // Numery kart Discover  zaczynaj si od 6011 i skadaj si z 16 cyfr.
         (($type == 'd') && ((substr($num,0,4) != 6011) ||
                 ($len != 16))) ) {
        // Nieprawidowy numer karty.
        return false;
    }

    // Jeli skrypt doszed do tego miejsca, to numer karty mona podda dziaaniu algorytmu Mod 10.
    // Najpierw nadamy liczbie posta tablicy znakw.
    $digits = str_split($num);

    // Nastpnie odwracamy kolejno elementw tablicy.
    $digits = array_reverse($digits);

    // Podwajamy co drug cyfr.
    foreach(range(1, count($digits) - 1, 2) as $x) {
        // Podwojenie.
        $digits[$x] *= 2;

        // Dla wartoci wikszych lub rwnych 10 dodajemy do siebie cyfry. Operacja jest o tyle atwa, e
        // pierwsza cyfra musi by jedynk.
        if ($digits[$x] > 9) {
            $digits[$x] = ($digits[$x] - 10) + 1;
        }
    }

    // Dodanie do siebie wszystkich wartoci w celu uzyskania sumy kontrolnej.
    $checksum = array_sum($digits);

    // Jeli suma dzieli si przez 10, zwracamy true, w przeciwnym razie false  numer jest nieprawidowy.
    return (($checksum % 10) == 0) ? true : false;
}

// Sprawdzenie poprawnoci kilku numerw kart kredytowych.
$nums = array(
    '344 2345 3466 4577' => 'a', '3794 2345 3466 4577' => 'a',
    '4938748398324' => 'v', '4123-1234-5342' => 'v',
    '51847293 84567434' => 'm', '5723x2345x2345x6161' => 'm',
    '6011 6011 6011 6011' => 'd', '6012 392563242423' => 'd',
    );

foreach ($nums as $num => $type) {
    $st = standardize_credit($num);
    $valid = validate_credit($st, $type);
    $output = $valid ? 'Prawidowy' : 'Nieprawidowy';
    echo "<p>{$st} - {$type} = {$output}</p>\n";
}
?>
