<?php
// Funkcja pobierajca cigi znakw w dowolnym formacie i zwracajca cigi tworzce poprawn liczb.
function standardize_number($num, $precision = false) {
    // Usunicie z cigu wszystkich znakw, ktre nie s cyframi bd znakiem -.
    $num = preg_replace('/[^-.0-9]/', '', $num);

    // Usunicie znakw znajdujcych si w rodku cigu znakw.
    $num = preg_replace('/(?<=.)-/', '', $num);

    // Po tych przeksztaceniach uzyskalimy cig, ktry interpreter PHP rozpozna jako prawidow liczb.
    // Zaokrglenie liczby, jeli podano argument $precision:
    if ($precision !== false) {
        $num = round($num, $precision);
    }

    return $num;
}

// Standaryzacja przykadowych cigw znakw zawierajcych liczby.
$nums = array('123.4643', 'Cze, kupiem dla Ciebie 42 kwiaty.',
                '-344-345.424', '+544,342.566');
foreach ($nums as $num) {
    $st = standardize_number($num, 2);
    echo "<p>{$num} = {$st}</p>\n";
}
?>

