<?php
// Funkcja, ktra pobiera numer ubezpieczenia spoecznego
// i standaryzuje go do postaci xxx-xx-xxxx.
function standardize_ssn($ssn) {
    // Usunicie z cigu wszystkich znakw niebdcych cyframi.
    $s = preg_replace('/[^0-9]/', '', $ssn);

    // Podzia cigu na odpowiednie czci i wstawienie mylnikw.
    return substr($s, 0, 3) . '-' . substr($s, 3, 2) . '-' . substr($s, 5);
}

// Funkcja sprawdzajca poprawno numeru SSN. Pobiera numer w postaci standardowej.
function validate_ssn($ssn) {
    // Podzia numeru na 3 czci.
    $parts = explode('-', $ssn);

    // Jeli dowolna z czci skada si z samych zer  numer jest nieprawidowy.
    foreach ($parts as $p) {
        if ($p == 0) {
            return false;
        }
    }

    // Jeli pierwsza cz tworzy liczb wiksz ni 772, numer jest nieprawidowy (regua ta w przyszoci moe      
    // wymaga aktualizacji).
    if ($parts[0] > 772) {
        return false;
    }

    // Jeli ostatni czon nie skada si z 4 znakw  numer jest nieprawidowy.
    if (strlen($parts[2]) != 4) {
        return false;
    }

    // W innym przypadku numer ma prawidowy format.
    return true;
}

// Standaryzacja i sprawdzenie poprawnoci kilku przykadowych numerw ubezpieczenia spoecznego.
$ssn = array('774 35 4688', '354-00-0103', '123456789', 'Witaj');
foreach ($ssn as $num) {
    $st = standardize_ssn($num);
    $valid = validate_ssn($st);
    $output = $valid ? 'Prawidowy' : 'Nieprawidowy';
    echo "<p>{$st} - {$output}</p>\n";
}
?>
