<?php
// Funkcja pobiera kody pocztowe USA
// i standaryzuje je do postaci xxxxx-xxxx.
function standardize_zip($input) {
    // Usunicie z cigu wszystkich znakw niebdcych cyframi.
    $digits = preg_replace('/[^0-9]/', '', $input);

    // Pobranie pierwszych piciu cyfr.
    $ret = substr($digits, 0, 5);

    // Jeli cig zawiera wicej ni 5 cyfr, doczenie ich za mylnikiem.
    if (strlen($digits) > 5) {
        $ret .= '-' . substr($digits, 5);
    }

    return $ret;
}

// Funkcja sprawdzajca poprawno kodu pocztowego.
// Kod musi by najpierw poddany standaryzacji.
function validate_zip($input) {
    // Podzia numeru na 2 czci.
    $parts = explode('-', $input);

    // Jeli pierwsza cz kodu nie skada si z piciu cyfr, jest on nieprawidowy.
    if (strlen($parts[0]) != 5) {
        return false;
    }

    // Jeli istnieje druga cz kodu, ktra nie skada si z czterech cyfr, jest on nieprawidowy.
    if (isset($parts[1]) && (strlen($parts[1]) != 4)) {
        return false;
    }

    // W innym przypadku kod ma prawidowy format.
    return true;
}

// Standaryzacja i sprawdzenie poprawnoci kilku przykadowych kodw pocztowych.
$zips = array('21771', '7177', 'x234 56', '12345-6789', '1313122',
    '14142-77743', '21705-123', '2177-1234', '1-1', '7.42');
foreach ($zips as $num) {
    $st = standardize_zip($num);
    $valid = validate_zip($st);
    $output = $valid ? 'Prawidowy' : 'Nieprawidowy';
    echo "<p>{$st} - {$output}</p>\n";
}
?>
