<?php
// Funkcja, ktra pobiera numery telefonw USA w wikszoci spotykanych formatw
// i standardyzuje je do postaci xxx-xxx-xxxx.
function standardize_phone($phone) {
    // Usunicie z cigu wszystkich znakw niebdcych cyframi.
    $p = preg_replace('/[^0-9]/', '', $phone);

    // Podzia cigu na odpowiednie czci i wstawienie mylnikw.
    return substr($p, 0, 3) . '-' . substr($p, 3, 3) . '-' . substr($p, 6);
}

// Funkcja sprawdzajca poprawno numeru telefonu.
// Przekazany numer musi by w postaci standardowej.
function validate_phone($phone) {
    // Podzia numeru na 3 czci.
    $parts = explode('-', $phone);

    // Jeli rodkowa cz to '555':
    if ($parts[1] == '555') {
        // Numer jest nieprawidowy, jeli ostatnia jego cz zawiera liczby od 0100 do 0199.
        if (($parts[2] >= 100) && ($parts[2] < 200)) {
            return false;
        }
    }

    // Numer jest nieprawidowy, jeli pierwsza cyfra numeru kierunkowego to 0 lub 1.
    if ($parts[0] < 200) {
        return false;
    }

    // Numer jest nieprawidowy, jeli druga cyfra numeru kierunkowego to 9.
    if ($parts[0]{1} == '9') {
        return false;
    }

    // Sprawdzenie, czy ostatnia cz numeru skada si z 4 cyfr.
    if (strlen($parts[2]) != 4) {
        return false;
    }

    // W innym przypadku numer ma prawidowy format.
    return true;
}

// Standardyzacja i sprawdzenie poprawnoci kilku przykadowych numerw telefonw.
$phones = array('(108)355-4688', '354-555-0103', '294.423.8437',
                '301 867-5309', '424-726 739', '829-56628426', 'Witaj');
foreach ($phones as $num) {
    $st = standardize_phone($num);
    $valid = validate_phone($st);
    $output = $valid ? 'Prawidowy' : 'Nieprawidowy';
    echo "<p>{$st} - {$output}</p>\n";
}
?>

