<?php
// Funkcja, ktra generuje ostrzeenia w przypadku, gdy uytkownik wprowadzi cza.
function warn_links($string) {
    // Znalezienie wszystkich czy we wprowadzonym cigu.
    preg_match_all('|<a\s+href\s*=\s*([\'"])(.*?)\1>|i',
        $string, $results, PREG_OFFSET_CAPTURE | PREG_SET_ORDER);

    // Przetwarzanie w ptli wszystkich wynikw   od koca, aby mona byo bez problemu zastpowa dane.
    // Dziki temu, po wykonaniu zastpowania, nie zmieniaj si przesunicia.
    foreach (array_reverse($results) as $r) {
        // Element [0][1] zawiera przesunicie cza, a [2][0]  
        //  adres URL. Pobranie hosta na podstawie adresu URL.
        $parsed = parse_url($r[2][0]);

        // Sprawdzenie hosta  jeli nie zostaa uyta nazwa hosta biecego serwera.
        $host = isset($parsed['host']) ? $parsed['host'] :
            $_SERVER['HTTP_HOST'];

        // Wstawienie ostrzeenia dotyczcego hosta.
        $string = substr_replace($string, " [{$host}] ", $r[0][1], 0);
    }

    return $string;
}

// Wywietlenie wprowadzonych danych, jeli przesano formularz metod POST.
if (count($_POST)) {
    echo "<p>Dane z ostrzeeniami na temat czy:</p>\n";
    echo warn_links($_POST['data']);
}
?>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" name="f1">
<p>Wprowad przykadowe dane:</p>
<p><textarea name="data" cols="80"
    rows="10"><?= @$_POST['data'] ?></textarea></p>
<p><input type="submit" /></p>
</form>
