<?php
// Funkcja obsugujca formatowanie BBCode. W obecnej postaci przeksztaca nastpujce znaczniki:
// [b] = <b>, [i] = <i>, [code] = <pre>,
// [quote] = <blockquote><i>, [img] = <img>.
// Przeksztaca rwnie podwjne znaki powrotu karetki na odpowiednie spacje.
function format_bbcode($string) {
    // Zdefiniowanie kilku bezporednich przeksztace.
    $trans = array( 'b' => 'b', 'i' => 'i', 'code' => 'pre' );

    // Wykorzystanie wyraenia regularnego do odszukania kodu BBCode i przetwarzanie w ptli cigu znakw.
    // Ptla jest konieczna po to, by obsuy kod wewntrz kodu.
    // Uyte wyraenie regularne wyszukuje cig w postaci [sowo] tekst [/sowo].
    while (preg_match('|\[([a-z]+)\](.*?)\[/\1\]|',
            $string, $r, PREG_OFFSET_CAPTURE)) {
        // W tym momencie element [0][0] zawiera pasujcy cig znakw;
        // element [0][1] zawiera przesunicie wewntrz tego cigu;
        // element [1][0] to drugi pasujcy cig  nazwa znacznika;
        // element [2][0] to trzeci pasujcy cig  zawarto znacznika.

        // Wygenerowanie kodu HTML na podstawie odczytanego znacznika.

        // Jeli jest to znacznik podlegajcy bezporedniemu przeksztaceniu:
        if (isset($trans[$r[1][0]])) {
            // Zastpienie znacznika jego wersj HTML.
            $replace = "<{$trans[$r[1][0]]}>{$r[2][0]}</{$trans[$r[1][0]]}>";
        }
        // Przypadek specjalny: quote.
        elseif ($r[1][0] == 'quote') {
            // Zastpienie dwoma znacznikami.
            $replace = "<blockquote><i>{$r[2][0]}</i></blockquote>";
        }
        // Przypadek specjalny: img.
        elseif ($r[1][0] == 'img') {
            // Utworzenie znacznika img na podstawie treci znacznika.
            $replace = "<img src=\"{$r[2][0]}\" />";
        } else {
            // Jeli znaleziono inny znacznik, jest on nieprawidowy, dlatego naley go obci.
            $replace = $r[2][0];
        }

        // Wykonanie operacji zastpowania.
        $string = substr_replace($string, $replace, $r[0][1],
            strlen($r[0][0]));
    }

    // Ostatnia czynno: zastpienie podwjnego znaku powrotu karetki znakiem
    // zakoczenia akapitu, tak by tekst wywietla si poprawnie na serwerach z systemem Windows.
    $string = str_replace("\r\n\r\n", '</p><p>', $string);
    // Poprawne wywietlanie w systemie Unix.
    $string = str_replace("\n\n", '</p><p>', $string);

    // Zwrcenie caego cigu ujtego w znaczniki akapitu.
    return "<p>{$string}</p>";
}

// Wywietlenie wprowadzonych danych, jeli przesano formularz metod POST.
if (count($_POST)) {
    // Usunicie z cigu znakw specjalnych, a nastpnie zinterpretowanie kodu BBCode:
    $bbcode = format_bbcode(htmlspecialchars($_POST['data']));

    // Wywietlenie cigu z kodem BBCode:
    echo "<p>rdo BBCode:</p>\n";
    echo '<p>', htmlspecialchars($bbcode), "</p>\n";

    // Wywietlenie sformatowanego tekstu.
    echo "<p>Sformatowany tekst BBCode:</p>\n";
    echo $bbcode;
}
?>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" name="f1">
<p>Wprowad przykadowe dane:</p>
<p><textarea name="data" cols="80"
    rows="10"><?= @$_POST['data'] ?></textarea></p>
<p><input type="submit" /></p>
</form>
