<?php
// Utworzenie funkcji zwracajcej list miesicy.
function month_options() {
    $retval = '';

    // Ptla dla wszystkich dwunastu miesicy.
    foreach(range(1,12) as $mon) {
        // Utworzenie znacznika czasu dla miesica.
        $time = mktime(0, 0, 0, $mon);
        // Zwrcenie nazwy miesica w postaci tekstowej za pomoc funkcji date.
        $name = date('F', $time);
        // Utworzenie listy opcji do wyboru.
        $retval .= "<option value=\"{$mon}\">{$name}</option>\n";
    }

    return $retval;
}

// Utworzenie funkcji, ktra wywietla list lat.
// Pierwszy parametr okrela liczb lat wstecz, jakie naley uwzgldni.
// Drugi parametr okrela liczb lat w przyszoci, jakie bd wywietlane.
function year_options($before, $after) {
    $retval = '';

    // Pocztek od biecego roku.
    $cyear = date('Y');

    // Przetwarzanie w ptli danego zakresu.
    foreach(range($cyear - $before, $cyear + $after) as $y) {
        // Zapisanie listy opcji.
        $retval .= "<option value=\"{$y}\">{$y}</option>\n";
    }

    return $retval;
}

// List mona teraz wywietli za pomoc prostego formularza.
?>
<form>
<p>Miesic:<select name="month"><?= month_options() ?></select></p>
<p>Rok:<select name="year"><?= year_options(5, 10) ?></select></p>
</form>
