<?php
// Wczenie tej biblioteki powoduje automatyczne okrelenie
// uywanego jzyka i uruchomienie pliku z odpowiedni wersj jzykow.

// Zdefiniowanie tablicy dostpnych jzykw.
$languages = array('pl' => 'Polski', , 'en' => 'Angielski','fr' => 'Francuski');

// Sprawdzenie, czy w cigu zapytania GET podano jzyk.
if (isset($_GET['lang'])) {
    // Jzyk okrelono, zatem ustawiamy zmienn $lang.
    $lang = $_GET['lang'];
    // Wysanie pliku cookie w celu zapamitania tego ustawienia przez 1 rok.
    setcookie('lang', $lang, time()+(3600*24*365));
}
// Wyszukiwanie pliku cookie, jeli ustawiono go wczeniej.
elseif (isset($_COOKIE['lang'])) {
    // Skorzystanie z pliku cookie.
    $lang = $_COOKIE['lang'];
} else {
    // W przeciwnym razie domylne ustawienie jzyka na polski.
    $lang = 'pl';
}

// Sprawdzenie, czy cig jzyka jest prawidowy.
if (!(in_array($lang, array_keys($languages)))) {
    die("BD: Nieprawidowy cig opisu jzyka!");
}

// Wczenie waciwego pliku wersji jzykowej.

require_once "{$lang}.php"

// Jedn z ostatnich operacji jest utworzenie funkcji umoliwiajcej 
// wywietlanie dostpnych jzykw.
function switch_language_options() {
    // Wczenie kilku potrzebnych zmiennych globalnych.
    global $text, $languages, $lang;

    // Rozpoczcie cigu od instrukcji switch specyficznej dla jzyka:
    $retval = $text['switch'];

    // Przetwarzanie w ptli dostpnych jzykw w celu wywietlenia opcji.
    $get = $_GET;
    foreach ($languages as $abbrv => $name) {
        // Utworzenie cza. Zignorowanie cza biecego.
        if ($abbrv !== $lang) {
            // Utworzenie cigu zapytania GET dla wybranego jzyka.
            $get['lang'] = $abbrv;
            $url = $_SERVER['PHP_SELF'] . '?' . http_build_query($get);
            $retval .= " <a href=\"{$url}\">{$name}</a>";
        }
    }

    // Zwrcenie cigu zapytania.
    return $retval;
}
?>
