<?php
// Funkcja konfigurujca i obsugujca buforowanie wynikw.
// Jedyny opcjonalny parametr suy do okrelenia liczby sekund, jakie musz upyn
//  przed ponownym utworzeniem strony (domylnie jest to 1 godzina).
function cache_page($refresh = 3600) {
    // Wygenerowanie nazwy pliku dla wersji umieszczonej w buforze. Nazwa jest generowana
    //  na podstawie oryginalnej nazwy pliku oraz zmiennych GET i POST. Nastpnie za pomoc funkcji sha1()
    //  tworzony jest 40-znakowy cig. Dziki temu unikamy problemw z limitem dugoci nazwy pliku.
    $hash = sha1($_SERVER['PHP_SELF'] . '|G|' . serialize($_GET) .
        '|P|' . serialize($_POST));

    // Utworzenie waciwej nazwy pliku, w ktrym jest dostpna strona. Bdzie ona zapisana w
    //  podkatalogu o nazwie 'cache' w katalogu, w ktrym znajduje si ten skrypt.
    $file = dirname(__FILE__) . '/cache/' . $hash;

    // Sprawdzenie, czy czas ostatniej modyfikacji jest mniejszy ni
    // czas biecy powikszony o czas odwieania.
    if ((time() - @filemtime($file)) < $refresh) {
        // Nie trzeba nic robi. Zwrcenie pliku i wyjcie.
        readfile($file);
        exit();
    } else {
        // W innym przypadku naley utworzy stron i j zapisa.
        // W tym celu najpierw trzeba uniemoliwi uytkownikowi przerwanie dziaania skryptu 
        // w tym momencie, aby zyska pewno, e strona zostanie wygenerowana.
        ignore_user_abort();

        // Zdefiniowanie funkcji zamykajcej, ktrej zadaniem bdzie zapewnienie poprawnego
        // zakoczenia generowania strony w przypadku przerwania dziaania skryptu (niezalenie od przyczyny).
        register_shutdown_function('_cache_page_exit', $file);

        // Rozpoczcie buforowania wyniku.
        ob_start();
    }
}

// Utworzenie funkcji zamykajcej, ktra bdzie wywoywana przy zakoczeniu dziaania
// skryptu w celu wykonania operacji porzdkujcych.
function _cache_page_exit($file) {
    // Zakoczono buforowanie. Najpierw naley pobra zawarto strony 
    // i wywietli j uytkownikowi.
    $output = ob_get_flush();

    // Oprnienie buforw, aby uytkownik uzyska wszystkie dane po zakoczeniu dziaania skryptu.
    flush();

    // Zapisanie danych w pliku bufora poprzez nadpisanie biecej zawartoci,
    // jeli ju znajdowaa si w buforze. danie blokady i wycznoci zapisu po to, 
    // by dwie kopie wykonywane w tym samym czasie nie kolidoway z sob.
    file_put_contents($file, $output, LOCK_EX);
}
?>
