<?php
// Najpierw obsuga konfiguracji. Odczytanie wartoci GET
//  i przypisanie wartoci domylnych dla nieistniejcych parametrw.
$page = (isset($_GET['page']) && ($_GET['page'] > 0))
    ? intval($_GET['page']) : 1;
$view = (isset($_GET['view']) && ($_GET['view'] > 0))
    ? intval($_GET['view']) : 10;

// Utworzenie testowych danych, ktre zostan podzielone na strony. Wykorzytsamy do tego alfabet.
$data = range('a', 'z');

// Nastpnie podzielimy dane na rwne czci, na podstawie parametru $view.
$pages = array_chunk($data, $view, true);

// Wywietlenie czci danych, ktrej zada uytkownik.
echo "<p>Wyniki:</p>\n<p>\n";
foreach($pages[$page - 1] as $num => $datum) {
    echo $num + 1, ". {$datum}<br />\n";
}
echo "</p>\n";

// Utworzenie opcji zmiany przegldanej strony.
echo '<p>Przejd do strony: |';
$get = $_GET;
foreach(range(1, count($pages)) as $p) {
    // Jeli to jest bieca strona:
    if ($page == $p) {
        echo " {$p} |";
    } else {
        // Trzeba przekaza waciw opcj. Najpierw wygenerujemy potrzebny URL.
        // Naley zdublowa przekazany cig zapytania, zastpujc wartoci
        //  okrelajce numer strony nowymi wartociami. Najatwiej mona to zrobi poprzez pobranie
        //  biecej warto z tablicy $_GET, aktualizacj jej i ponowne utworzenie cigu zapytania.
        $get['page'] = $p;
        $query = http_build_query($get);
        echo " <a href=\"{$_SERVER['PHP_SELF']}?{$query}\">{$p}</a> |";
    }
}
echo "</p>\n";

// Wywietlenie opcji umoliwiajcych wybr liczby wynikw na stronie.
$options = array(3, 5, 10, 50);

// Utworzenie nowej kopii tablicy $_GET.
$get = $_GET;

// W przypadku modyfikacji liczby wynikw na stronie zawsze ustawiamy numer strony na 1.
unset($get['page']);

// Opcj zmiany liczby wynikw wywietlamy tak samo, jak dostpne strony.
echo '<p>Liczba wynikw na stronie: |';
foreach($options as $o) {
    // Jeli jest to opcja bieca:
    if ($o == $view) {
        echo " {$o} |";
    } else {
        // Nadanie nowej wartoci poprzez ponowne utworzenie parametru GET.
        $get['view'] = $o;
        $query = http_build_query($get);
        echo " <a href=\"{$_SERVER['PHP_SELF']}?{$query}\">{$o}</a> |";
    }
}
echo "</p>\n";
?>
