<?php
// Zdefiniowanie funkcji tworzcej wykres.
// Funkcja pobiera parametry: dane do zaprezentowania na wykresie i maksymaln wysoko.
// Mona te przekaza 4 parametry oznaczajce kolory: obramowania,
//  ta, supkw i siatki. S to parametry opcjonalne.
function create_chart($data, $height,
        $bars = 'red', $bg = 'white', $border = 'black', $grid = '#DDD') {
    // Najpierw naley zapewni, aby przy kadym wywoaniu funkcji by
    // generowany nowy numer wykresu. Jest to potrzebne do rozrnienia
    // wykresw, jeli jest ich wicej ni jeden na stronie.
    static $idx = 0;
    $idx++;

    // Zakadamy, e wysoko supkw bdzie o 2 piksele mniejsza ni wysoko caego wykresu (rezerwa na     
    // obramowanie).
    $height -= 2;

    // Nastpnie obliczymy wspczynnik skali. Maksymaln warto troch powikszymy, poniewa
    // z powodw estetycznych nie chcemy, by supek osign grn krawd wykresu.
    $scale = $height / (max($data) * 1.05);

    // Obliczenie szerokoci.
    $width = count($data);

    // Teraz mona utworzy arkusz CSS uywany do rysowania wykresu.
    echo "
<style>
#chartout{$idx} {
    position: relative;
    height: ", $height + 2, "px;
    width: ", $width + 2, "px;
    background-color: {$border};
}
#chartin{$idx} {
    position: absolute;
    top: 1px;
    left: 1px;
    height: {$height}px;
    width: {$width}px;
    background-color: {$bg};
}
.bar{$idx} {
    position: absolute;
    bottom: 0px;
    background-color: {$bars};
    width: 1px;
    overflow: hidden;
}
.grid{$idx} {
    position: absolute;
    left: 0px;
    height: 1px;
    width: {$width}px;
    background-color: {$grid};
    padding: 0px;
    margin: 0px;
    overflow: hidden;
}
</style>
";

    // Wywietlenie podstawowych czci wykresu.
    echo "
<div id='chartout{$idx}'><div id='chartin{$idx}'>
";

    // Utworzenie wzoru siatki  podzielenie przestrzeni na 5 czci.
    foreach(range(1,3) as $line) {
        $lh = round($line * ($height / 5));
        echo "<div class='grid{$idx}' style='top: {$lh}px'></div>\n";
    }

    // Przetwarzanie w ptli wszystkich elementw tablicy w celu utworzenia supkw.
    foreach ($data as $pos => $val) {
        $barheight = round($val * $scale);
        echo "<div class='bar{$idx}' style='left:{$pos}px;
height:{$barheight}px'></div>\n";
    }

    // Zakoczenie.
    echo "\n</div></div>\n";
}

// Wygenerowanie 200 losowych punktw danych w dwch tablicach.
$chartdata = array();
$chartdata2 = array();
for ($i = 0; $i < 200; $i++) {
    $chartdata[$i] = rand(1,1000);
    $chartdata2[$i] = rand(1,1000);
}

// Wygenerowanie wykresu o wysokoci 100 pikseli na podstawie tych danych.
create_chart($chartdata, 100);

// Wygenerowanie innego wykresu o wysokoci 50 pikseli z wykorzystaniem innych kolorw.
create_chart($chartdata2, 50, '#0C0', 'black', 'black', '#666');
?>
