<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>System Menu</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
</head>
<body>
<?php
// Potrzebna jest funkcja-kontener, ktra utworzy elementy menu i przekae je
// do systemu menu. Funkcja pobiera tablic opcji menu, wsprzdne x/y okrelajce
//  jego lokalizacj, szeroko dla wszystkich polece menu (po to, by wyglday
// jednolicie), rne kolory oraz znak, bdcy indeksem okrelonego menu. Ostatniego
//  parametru nie trzeba podawa w przypadku tworzenia jednego systemu menu na stronie.
//  W przypadku tworzenia drugiego systemu naley poda inny znak.
function create_full_menu_system($menuarray, $x, $y, $width,
                 $fgcolor, $bgcolor, $txtcolor, $bordercolor, $idx = 'a') {
    // Najpierw skorzystamy z funkcji create_menu w ceu utworzenia kodu XHTML i
    // uzykania listy wszystkich menu utworzonych w ten sposb.
    $xhtml = '';
    $menus = array();
    create_menu($menuarray, $xhtml, $menus, $idx, $idx);

    // Przed wyprowadzeniem xhtml do przegldarki przygotujemy list menu.
    $menulist = implode(',', $menus);

    // Wyprowadzenie kodu CSS specyficznego dla tego systemu menu.
    echo "
<style type=\"text/css\">
#menu{$idx} {
    visibility: visible;
    padding: 0px;
}
.menu_{$idx} {
    position: absolute;
    top: {$x}px;
    left: {$y}px;
    visibility: hidden;
    border-top: 3px solid {$bordercolor};
    padding: 0px 0px 0px 8px;
}
.menu_{$idx} ul {
    list-style-type: none;
    padding: 0px;
    margin: 0px;
    border-right: 1px solid {$bordercolor};
    border-bottom: 1px solid {$bordercolor};
    border-left: 1px solid {$bordercolor};
}
.menu_{$idx} li {
    border: 1px solid {$bordercolor};
}
.menu_{$idx} a {
    width: {$width}px;
    display: block;
    background-color: {$bgcolor};
    text-align: right;
    text-decoration: none;
    font-family: Geneva, Arial, Helvetica, sans-serif;
    font-size: 12px;
    color: {$txtcolor};
    padding: 2px;
    margin: 0px;
}
.menu_{$idx} a:hover {
    background-color: {$fgcolor};
}
</style>
";

    // Utworzenie kodu JavaScript potrzebnego do uruchomienia tego menu.
    echo "
<script type=\"text/javascript\">
function display_menu_{$idx}(main, submenu, line) {
    // Wymuszenie zniknicia wszystkich biecych menu poza nadrzdnymi.
    remove_menus_{$idx}('menu' + main);

    // Wywietlenie waciwego podmenu.
    // Znalezienie odpowiedniego bloku nadrzdnego.
    var pblock = document.getElementById('menu' + main);

    // Pobranie wsprzdnej Y nowego elementu div.
    var y = line.offsetTop + pblock.offsetTop + 12;

    // Wyznaczenie wsprzdnej X nowego elementu div.
    var x = pblock.offsetLeft + pblock.offsetWidth;

    // Wywietlenie go i przeniesienie na odpowiedni pozycj.
    var newblock = document.getElementById('menu' + main + submenu);
    newblock.style.top = y + 'px';
    newblock.style.left = x + 'px';
    newblock.style.visibility = 'visible';

    // Wyzerowanie licznika czasu, typowe dla zdarze mouseover.
    on_over_{$idx}();
}

// Utworzenie tablicy zawierajcej wszystkie podmenu.
document.submenus_{$idx} = new Array({$menulist});
// Funkcja, ktra w sposb siowy powoduje, e wszystkie podmenu staj si niewidoczne.
// Ma opcjonalny parametr wykorzystywany przez podmenu do uniknicia
// zamknicia menu nadrzdnego. Aby usun wszystkie menu, naley ustawi go na warto''.
function remove_menus_{$idx}(except) {
    for (i = 0; i < document.submenus_{$idx}.length; i++) {
        // Zamknicie biecego podmenu tylko wtedy, gdy nie spenia kryteriw menu 'except'.
        if (document.submenus_{$idx}[i] !=
                except.substr(0,document.submenus_{$idx}[i].length)) {
            document.getElementById(document.submenus_{$idx}[i]
                ).style.visibility = 'hidden';
        }
    }
}

function on_out_{$idx}() {
    // Po opuszczeniu podmenu, uruchomienie licznika czasu, po ktrym menu znika.
    document.menutimer_{$idx} =
        window.setTimeout(\"remove_menus_{$idx}('')\", 1000);
}

function on_over_{$idx}() {
    // Wyzerowanie licznika czasu wtedy, gdy uytkownik korzysta z podmenu.
    window.clearTimeout(document.menutimer_{$idx});
}

function on_over_clear_{$idx}() {
    // Jeli uytkownik wskazuje gwn opcj menu, bez podmenu, wyczyszczenie podmenu.
    remove_menus_{$idx}('');
    on_over_{$idx}();
}
</script>
";

    // Teraz mona umieci kod XHTML w strumieniu wynikowym.
    echo $xhtml;
}

// Nastpnie jest potrzebna funkcja wywoywana rekurencyjnie, ktra bdzie
// przetwarza tablic w ptli i tworzy dla niej kod XHTML.
function create_menu($m, &$xhtml, &$menus, $subtext = 'a', $top = 'a') {
    // Pobranie pierwszego znaku zmiennej subtext potrzebnego do wykorzystania przez funkcje.
    $idx = $subtext{0};

    // Sprawdzenie, czy menu powinno ulec zniszczeniu po przemieszczeniu wskanika myszy poza nie.
    $mousediv = " onmouseout=\"on_out_{$idx}()\"
onmouseover=\"on_over_{$idx}()\"";
    $mitem = '';
    if ($subtext !== $top) {
        $mitem = " onmouseover=\"on_over_{$idx}()\"";
    } else {
        $mitem = " onmouseover=\"on_over_clear_{$idx}()\"";
    }

    // Rozpoczcie tworzenia kontenera dla tego menu.
    $xhtml .= "
<div id=\"menu{$subtext}\" class=\"menu_{$idx}\"{$mousediv}>
<ul id=\"list{$subtext}\">
";

    // Przetwarzanie w ptli wszystkich elementw tablicy i umieszczanie menu w wyniku.
    $subs = array();
    $counter = 'a';
    foreach ($m as $name => $val) {
        // Jeli to jest tablica:
        if (is_array($val)) {
            // Umieszczenie podmenu w tablicy subs pod indeksem counter.
            $subs[$counter] = $val;

            // Wyprowadzenie wiersza.
            $xhtml .= "
<li><a href=\"javascript:void(0)\"
 onmouseover=\"display_menu_{$idx}('{$subtext}','{$counter}',this)\"
 >{$name} &gt;&gt;</a></li>
";

            // Inkrementacja licznika.
            $counter++;
        } else {
            // To jest adres URL. Utworzenie cza.
            $xhtml .= "<li><a href=\"{$val}\"{$mitem}>{$name}</a></li>\n";
        }
    }

    // Zakoczenie elementu div.
    $xhtml .= "</ul></div>\n";

    // Rekurencyjne wywoywanie funkcji dla wszystkich podmenu.
    foreach ($subs as $stext => $submenu) {
        // Zapisanie kopii menu o podanej nazwie.
        $menus[] = "'menu{$subtext}{$stext}'";
        // Wywoanie funkcji.
        create_menu($submenu, $xhtml, $menus, $subtext . $stext, $top);
    }
}

// Deklaracja systemu menu w postaci tablicy z podtablicami przeznaczonymi na podmenu.
$menu = array(
    'Przydatne witryny' => array(
        'Wyszukiwarki' => array(
            'Google' => 'http://google.com/',
            'Yahoo' => 'http://yahoo.com/'
            ),
        'Przegldarki WWW' => array(
            'Mozilla' => 'http://mozilla.org/',
            'Opera' => 'http://opera.com/'
            )
         ),
    'Aktualnoci' => array(
        'BBC' => 'http://news.bbc.co.uk/',
        'Washington Post' => 'http://washingtonpost.com/',
        'New York Times' => 'http://nytimes.com/',
        'Slashdot' => 'http://slashdot.org/'
        ),
    'Strona domowa' => 'http://eliw.com/'
    );

// Utworzenie drugiego menu.
$menu2 = array(
    'Tutaj nie ma' => array(
        'Niczego ciekawego' => array(
            'Do ogldania' => array(
                'Naprawd!' => 'http://php.net/'
                )
            )
        ),
    'Strona domowa' => 'http://eliw.com/'
    );

// Wywoanie funkcji.
create_full_menu_system($menu, 5, 5, 160,
    '#00CCFF', '#CCCCCC', 'blue', 'black');
create_full_menu_system($menu2, 150, 250, 120,
    'black', '#CC0000', 'white', '#660000', 'b');
?>
</body>
</html>
