<?php
//  Bdziemy generowa grafik, zatem rozpoczynamy od prawidowych nagwkw.
header('Content-type: image/jpeg');

// Rejestracja funkcji zamykajcej, ktra zwrci plik z bufora w przypadku bdw.
function shutdown() {
    // Jeli nie udao si odczyta pliku.
    if (!(isset($GLOBALS['data'])) || !($GLOBALS['data'])) {
        // Zwrcenie pliku z bufora z uyciem bezwzgldnej cieki do pliku.
        readfile(dirname(__FILE__) . '/hubble_news.cache');
    }
}
register_shutdown_function('shutdown');

// Ustawienie niskiej wartoci limitu czasu, aby pobra plik z bufora, jeli nie uda si szybko pobra pliku ze 
// zdalnego serwera.
set_time_limit(5);

// Prba odczytania zdalnego pliku.
if ($data = @file_get_contents(
        'http://hubblesite.org/news/latest_big.php')) {
    // Zresetowanie limitu czasu, tak by nie nastpio jego przekroczenie podczas zapisu pliku w buforze.
    set_time_limit(60);

    // Udao si pobra plik  wywietlenie jego zawartoci.
    echo $data;

    // Teraz zapiszemy plik do bufora.
    // Do funkcji file_put_contents przekaemy flag LOCK_EX, ktra przed prb zapisu
    // do pliku ustanawia blokad na wyczno.
    ignore_user_abort(true);
    file_put_contents(dirname(__FILE__) . '/hubble_news.cache',
        $data, LOCK_EX);
}
?>
