<?php
// Funkcja tworzca pomocniczy katalog blokady. Jest to rozwizanie
// alternatywne w przypadku niemonoci skorzystania z funkcji flock().
function lock($filename) {
    // Uniemoliwienie uytkownikowi anulowania skryptu.
    ignore_user_abort(true);

    // Zainicjowanie licznika. Chcemy, aby skrypt podj tylko
    // kilka prb uzyskania blokady.
    $counter = 0;

    // Ptla do czasu uzyskania blokady lub zakoczenie dziaania skryptu w przypadku braku takiej moliwoci.
    do {
        // Oczekiwanie przez czas rwny liczbie sekund podniesionej do kwadratu (za kadym razem duej).
        sleep($counter * $counter);

        // Utworzenie katalogu.
        $success = @mkdir("{$filename}.dirlock");
    }
    while ( !($success) &&  ($counter++ < 10) );

    // Jeli licznik wynosi 11, to ustanowienie blokady nie powiodo si.
    if ($counter == 11) {
        die ('BD: Nie mona uzyska wycznoci!');
    }

    // W innym przypadku udao si ustanowienie blokady  zrobione.
}

// Funkcja obsugujca zwolnienie blokady.
function unlock($filename) {
    // Usunicie katalogu.
    if (!(rmdir("{$filename}.dirlock"))) {
        die ('BD: Nie mona zwolni blokady wycznoci!');
    }

    // Usunicie ograniczenia moliwoci anulowania skryptu.
    ignore_user_abort(false);
}

// Wykorzystanie zdefiniowanych funkcji w celu wykonania penych ptli odczytu (zapisu)
// wraz z inkrementacj licznika operacji zapisu do pliku.

// Uzyskanie blokady.
$lock = lock('data.counter');

// Odczytanie pliku, obliczenie licznika i zapisanie danych.
$filedata = @file('data.counter');
$count = isset($filedata[0]) ? $filedata[0] + 1 : 1;
file_put_contents('data.counter', $count);

// Zwolnienie blokady na wyczno.
unlock('data.counter');

// Wywietlenie zawartoci pliku, aby mona byo zaobserwowa zmiany.
echo '<pre>';
readfile('data.counter');
echo '</pre>';
?>
