<?php
// Funkcja tworzca pomocniczy plik blokady.
function lock($filename) {
    // Uniemoliwienie uytkownikowi anulowania skryptu.
    ignore_user_abort(true);

    // Prba otwarcia i (lub) utworzenia pliku blokady.
    if (!($fp = fopen("{$filename}.lock", 'w'))) {
        die ('BD: Nie mona otworzy pliku!');
    }

    // Prba uzyskania wycznoci.
    if (!(flock($fp, LOCK_EX))) {
        die ('BD: Nie mona uzyska wycznoci!');
    }

    // Mamy wyczno, zwrcenie wskanika do zablokowanego pliku.
    return $fp;
}

// Funkcja obsugujca zwolnienie blokady.
function unlock($filepointer) {
    // Odblokowanie pomocniczego pliku.
    if (!(flock($filepointer, LOCK_UN))) {
        die ('BD: Nie mona zwolni blokady wycznoci!');
    }

    // Usunicie ograniczenia moliwoci anulowania skryptu.
    ignore_user_abort(false);
}

// Wykorzystanie zdefiniowanych funkcji w celu wykonania penych ptli odczytu (zapisu)
// wraz z inkrementacj licznika operacji zapisu do pliku.

// Uzyskanie blokady.
$lock = lock('data.counter');

// Odczytanie pliku.
$filedata = @file('data.counter');

// Obliczenie wartoci nowego licznika.
$count = isset($filedata[0]) ? $filedata[0] + 1 : 1;

// Teraz mona zapisa dane.
file_put_contents('data.counter', $count);

// Zwolnienie blokady na wyczno.
unlock($lock);

// Wywietlenie zawartoci pliku, aby mona byo zaobserwowa zmiany.
echo '<pre>';
readfile('data.counter');
echo '</pre>';
?>
