<?php
// Funkcja porwnujca dwie wersje pliku.
function diff($old_file, $new_file, $type = 'array') {
    // Wczytanie obu plikw do pamici w celu ich porwnania.
    $old = file($old_file);
    $new = file($new_file);

    // Zainicjowanie licznikw wierszy w starym i nowym pliku.
    $oc = 0;
    $nc = 0;

    // Zapisanie liczby wierszy kadej z tablic w celu pniejszego wielokrotnego wykorzystania.
    $nold = count($old);
    $nnew = count($new);

    // Zainicjowanie maszyny stanw na stan 0.
    $state = 0;

    // Zainicjowanie tablic danych w celu zapisania usunitych i dodanych wierszy.
    $removed = array();
    $added = array();

    // Ptla maszyny stanw  rozpoczcie przetwarzania.
    while ($state < 3) {
        switch ($state) {
            case 0: // Wzajemne porwnywanie. Spodziewamy si, e porwnywane fragmenty bd 
                                          // z sob zgodne.
                // Pominicie wszystkich pasujcych do siebie fragmentw do czasu znalezienia takich, 
                                  // ktre do siebie nie pasuj.
                while (($oc < $nold) && ($nc < $nnew) &&
                        ($old[$oc] == $new[$nc]))  {
                    $oc++;
                    $nc++;
                }

                // Znalezienie rnic.
                if (($oc == $nold) && ($nc == $nnew)) {
                    // Zakoczono, ustawienie stanu na warto 3.
                    $state = 3;
                } elseif ($oc == $nold) {
                    // Fragment ze starej wersji by wikszy, zatem wszystko, co pozostao
                    // w tablicy z zawartoci nowego pliku, to tre, ktr dodano.
                    $added = array_merge($added, range($nc, $nnew - 1));
                    $state = 3;
                } elseif ($nc == $nnew) {
                    // Fragment nowej wersji pliku by wikszy, zatem wszystko, co pozostao
                    // w tablicy ze star wersj, zostao usunite.
                    $added = array_merge($added, range($nc, $nnew - 1));
                    $state = 3;
                } else {
                    // Znaleziono rnic, ustawienie stanu na 1.
                    $state = 1;
                }
                break;
            case 1: // Wyszukiwanie cigu pasujcego do wiersza nowego pliku.
                $oc2 = $oc;
                // Dopty, dopki pliki nie s z sob zgodne lub nie osignito koca pliku.
                while (($oc2 < $nold) && ($old[$oc2] !== $new[$nc])) {
                    $oc2++;
                }

                // Znalezienie przyczyny rnic.  Jeli osignito koniec:
                if ($oc2 == $nold) {
                    // Dodano nowy wiersz - zapisanie go.
                    $added[] = $nc;

                    // Inkrementacja licznika i zresetowanie algorytmu.
                    $nc++;
                    $state = 0;
                } else {
                    // Znaleziono pasujcy fragment, zatem wszystkie wiersze od
                    // pocztku analizowanego fragmentu do tego miejsca usunito.
                    $removed = array_merge($removed, range($oc, $oc2 - 1));
                    // Zresetowanie licznika do nowej lokalizacji.
                    $oc = $oc2;
                    // Zmiana stanu z powrotem na 0 w celu zresetowania algorytmu.
                    $state = 0;
                }
                break;
        }
    }

    // W tym momencie wszystkie rnice powinny znajdowa si w pamici.
    // Okrelenie, na podstawie trzeciego opcjonalnego parametru,
    // formatu ich zwrcenia.

    // W przypadku wartoci 'lines' zwrcenie
    //  zmodyfikowanych wierszy.
    if ($type == 'lines') {
        $retval = '';
        // Wyyszukanie wszystkich moliwych wartoci w ptli w celu uzyskania uporzdkowanego wyniku.
        foreach(range(0, max($nold, $nnew) - 1) as $line) {
            // Wywietlenie usunitego wiersza.
            if (isset($removed[$line])) {
                $retval .= "-{$line}: {$deleted[$line]}\n";
            }
            // Wywietlenie dodanego wiersza.
            if (isset($removed[$line])) {
                $retval .= "-{$line}: {$deleted[$line]}\n";
            }
        }
    }
    // Jeli przekazano parametr 'visual', stworzenie wizualizacji rnic.
    elseif ($type == 'visual') {
        // Utworzymy tabel, w ktrej kady plik bdzie si wywietla w oddzielnej kolumnie (komrce),
        // a usunite (dodane) wiersze bd odpowiednio wyrnione.

        // Zadeklarowanie potrzebnych stylw CSS.
        $retval = '
<style>
.diff td {
    border: 1px solid black;
    padding: 5px;
    font-family: "Courier New", Courier, mono;
    font-size: 10px;
    vertical-align: top;
}
.diff .removed {
    background-color: #FF9999;
}
.diff .added {
    background-color: #00CC00;
}
</style>
';
        // Rozpoczcie tabeli i pierwszej komrki (ze star wersj pliku).
        $retval .= '<table class="diff"><tr><td>Pierwotna wersja pliku:<br /><pre>';

        // Ptla dla starej wersji pliku i podwietlenie rnic w miar potrzeb.
        foreach ($old as $num => $line) {
            // Jeli wiersze usunito, odpowiednie wyrnienie ich, w innym przypadku zostan wywietlone.
            if (in_array($num, $removed)) {
                $retval .= $num . '. ' . '<span class="removed">' .
                        htmlspecialchars($line) . '</span>';
            } else {
                $retval .= $num . '. ' . htmlspecialchars($line);
            }
        }

        // Zamknicie komrki i rozpoczcie komrki dla nowej wersji pliku.
        $retval .= '</pre></td><td>Nowa wersja pliku:<br /><pre>';

        // Powtrzenie tego samego procesu dla nowej wersji pliku.
        foreach ($new as $num => $line) {
            if (in_array($num, $added)) {
                $retval .= $num . '. ' . '<span class="added">' .
                        htmlspecialchars($line) . '</span>';
            } else {
                $retval .= $num . '. ' . htmlspecialchars($line);
            }
        }

        // Zamknicie tabeli. Pliki porwnano.
        $retval .= '</pre></td></tr></table>';
    }
    // W innym przypadku wynik zostanie zwrcony w postaci tablic.
    else {
        $retval = array('removed' => $removed, 'added' => $added);
    }

    // Zwrcenie wyniku i zakoczenie funkcji.
    return $retval;
}

// Przetestowanie funkcji dla dwch plikw.
echo diff('file-1.1.php', 'file-1.2.php', 'visual');
?>
